/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.style;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jdom.Namespace;
import org.openconcerto.openoffice.Style;
import org.openconcerto.openoffice.StyleProperties;

public class SideStyleProperties
extends StyleProperties {
    private static final Pattern spacePattern = Pattern.compile(" +");

    public SideStyleProperties(Style style, String propPrefix) {
        super(style, propPrefix);
    }

    public final String getBorder(Side s) {
        return this.getSideAttribute(s, "border", this.getNS("fo"));
    }

    public final Map<Side, String> getBorders() {
        HashMap<Side, String> res = new HashMap<Side, String>();
        Side[] sideArray = Side.values();
        int n = sideArray.length;
        int n2 = 0;
        while (n2 < n) {
            Side s = sideArray[n2];
            String b = this.getBorder(s);
            if (b != null) {
                res.put(s, b);
            }
            ++n2;
        }
        return res;
    }

    public final String[] getBorderLineWidth(Side s) {
        String res = this.getSideAttribute(s, "border-line-width", this.getElement().getNamespace("style"));
        return res == null ? null : spacePattern.split(res);
    }

    protected final String getSideAttribute(Side s, String attrName, Namespace ns) {
        String allBorder = this.getElement().getAttributeValue(attrName, ns);
        String res = allBorder != null ? allBorder : this.getElement().getAttributeValue(String.valueOf(attrName) + "-" + s.name().toLowerCase(), ns);
        return res;
    }

    public static enum Side {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

