/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.style;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.Arrays;
import org.jdom.Element;
import org.openconcerto.openoffice.LengthUnit;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.Style;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.style.SideStyleProperties;

public class PageLayoutStyle
extends Style {
    public static final StyleDesc<PageLayoutStyle> DESC = new StyleDesc<PageLayoutStyle>(PageLayoutStyle.class, XMLVersion.OD, "page-layout", "pm"){
        {
            this.getRefElementsMap().putAll((Object)"style:page-layout-name", Arrays.asList("presentation:notes", "style:handout-master", "style:master-page"));
        }

        @Override
        public PageLayoutStyle create(ODPackage pkg, Element e) {
            return new PageLayoutStyle(pkg, e);
        }
    };
    public static final StyleDesc<PageLayoutStyle> DESC_OO = new StyleDesc<PageLayoutStyle>(PageLayoutStyle.class, XMLVersion.OOo, "page-master", "pm"){
        {
            this.getRefElementsMap().putAll((Object)"style:page-master-name", Arrays.asList("presentation:notes", "style:handout-master", "style:master-page"));
        }

        @Override
        public PageLayoutStyle create(ODPackage pkg, Element e) {
            return new PageLayoutStyle(pkg, e);
        }
    };
    private PageLayoutProperties props = null;

    public PageLayoutStyle(ODPackage pkg, Element tableColElem) {
        super(pkg, tableColElem);
    }

    public final PageLayoutProperties getPageLayoutProperties() {
        if (this.props == null) {
            this.props = new PageLayoutProperties(this);
        }
        return this.props;
    }

    public final Color getBackgroundColor() {
        return this.getPageLayoutProperties().getBackgroundColor();
    }

    public static class PageLayoutProperties
    extends SideStyleProperties {
        public PageLayoutProperties(Style style) {
            super(style, DESC.getElementName());
        }

        public final String getRawMargin(SideStyleProperties.Side s) {
            return this.getSideAttribute(s, "margin", this.getNS("fo"));
        }

        public final BigDecimal getMargin(SideStyleProperties.Side s, LengthUnit in) {
            return LengthUnit.parseLength(this.getRawMargin(s), in);
        }

        public final BigDecimal getPageWidth(LengthUnit in) {
            return this.getLengthAttr("page-width", "fo", in);
        }

        public final BigDecimal getPageHeight(LengthUnit in) {
            return this.getLengthAttr("page-height", "fo", in);
        }

        private final BigDecimal getLengthAttr(String attrName, String attrNS, LengthUnit in) {
            return LengthUnit.parseLength(this.getElement().getAttributeValue(attrName, this.getNS(attrNS)), in);
        }
    }
}

