/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.spreadsheet.Column;
import org.openconcerto.openoffice.spreadsheet.ColumnStyle;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.Range;
import org.openconcerto.openoffice.spreadsheet.Row;
import org.openconcerto.openoffice.spreadsheet.SheetTableModel;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.openoffice.spreadsheet.TableCalcNode;
import org.openconcerto.openoffice.spreadsheet.TableStyle;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.xml.JDOMUtils;

public class Table<D extends ODDocument>
extends TableCalcNode<TableStyle, D> {
    private final List<Row<D>> rows = new ArrayList<Row<D>>();
    private int headerRowCount;
    private final List<Column<D>> cols = new ArrayList<Column<D>>();
    private int headerColumnCount;
    private static Pattern regexp = Pattern.compile("((^.*)\\.(\\D*))((\\d*)$)");

    static Element createEmpty(XMLVersion ns) {
        Element col = Column.createEmpty(ns, null);
        Element row = Row.createEmpty(ns).addContent(Cell.createEmpty(ns));
        return new Element("table", ns.getTABLE()).addContent(col).addContent(row);
    }

    static final String getName(Element elem) {
        return elem.getAttributeValue("name", elem.getNamespace("table"));
    }

    public Table(D parent, Element local) {
        super(parent, local, TableStyle.class);
        this.readColumns();
        this.readRows();
    }

    private void readColumns() {
        this.read(true);
    }

    private final void readRows() {
        this.read(false);
    }

    private final void read(boolean col) {
        Tuple2<List<Element>, Integer> r = this.flatten(col);
        (col ? this.cols : this.rows).clear();
        for (Element clone : r.get0()) {
            if (col) {
                this.addCol(clone);
                continue;
            }
            this.addRow(clone);
        }
        if (col) {
            this.headerColumnCount = r.get1();
        } else {
            this.headerRowCount = r.get1();
        }
    }

    private final void addCol(Element clone) {
        this.cols.add(new Column(this, clone));
    }

    private Tuple2<List<Element>, Integer> flatten(boolean col) {
        ArrayList<Element> res = new ArrayList<Element>();
        Element header = this.getElement().getChild("table-header-" + this.getName(col) + "s", this.getTABLE());
        if (header != null) {
            res.addAll(this.flatten(header, col));
        }
        int headerCount = res.size();
        res.addAll(this.flatten(this.getElement(), col));
        return Tuple2.create(res, headerCount);
    }

    private List<Element> flatten(Element elem, boolean col) {
        String childName = this.getName(col);
        List children = elem.getChildren("table-" + childName, this.getTABLE());
        ListIterator iter = children.listIterator();
        while (iter.hasNext()) {
            Element row = (Element)iter.next();
            Attribute repeatedAttr = row.getAttribute("number-" + childName + "s-repeated", this.getTABLE());
            if (repeatedAttr == null) continue;
            row.removeAttribute(repeatedAttr);
            int index = iter.previousIndex();
            int repeated = Integer.parseInt(repeatedAttr.getValue());
            if (repeated > 60000) {
                repeated = 10;
            }
            int i = 0;
            while (i < repeated - 1) {
                Element clone = (Element)row.clone();
                children.add(index, clone);
                ++i;
            }
            iter = children.listIterator(index + repeated);
        }
        return children;
    }

    public final String getName() {
        return Table.getName(this.getElement());
    }

    public final void setName(String name) {
        this.getElement().setAttribute("name", name, this.getODDocument().getVersion().getTABLE());
    }

    public void detach() {
        this.getElement().detach();
    }

    private final String getName(boolean col) {
        return col ? "column" : "row";
    }

    public final Object getPrintRanges() {
        return this.getElement().getAttributeValue("print-ranges", this.getTABLE());
    }

    public final void setPrintRanges(String s) {
        this.getElement().setAttribute("print-ranges", s, this.getTABLE());
    }

    public final void removePrintRanges() {
        this.getElement().removeAttribute("print-ranges", this.getTABLE());
    }

    public final synchronized void duplicateFirstRows(int nbFirstRows, int nbDuplicate) {
        this.duplicateRows(0, nbFirstRows, nbDuplicate);
    }

    public final synchronized void insertDuplicatedRows(int rowDuplicated, int nbDuplicate) {
        this.duplicateRows(rowDuplicated, 1, nbDuplicate);
    }

    public final synchronized void duplicateRows(int start, int count, int copies) {
        int stop = start + count;
        ArrayList<Element> clones = new ArrayList<Element>(count * copies);
        int i = 0;
        while (i < copies) {
            int l = start;
            while (l < stop) {
                Element r = this.rows.get(l).getElement();
                Element c = (Element)r.clone();
                List children = c.getChildren("table-cell", c.getNamespace());
                for (Element element : children) {
                    System.err.println("--------get table cell");
                    List lChild = element.getChildren("frame", element.getNamespace("frame"));
                    for (Element element2 : lChild) {
                        System.err.println("---------get frame");
                        Attribute attribute = element2.getAttribute("end-cell-address", c.getNamespace());
                        String value = attribute.getValue();
                        System.err.println(value);
                        Matcher matcher = regexp.matcher(value);
                        if (!matcher.matches() || matcher.groupCount() != 5) continue;
                        String result = matcher.group(1);
                        int val = Integer.parseInt(matcher.group(4));
                        result = String.valueOf(result) + (val += count * (i + 1));
                        attribute.setValue(result);
                        System.err.println(attribute.getValue());
                    }
                }
                clones.add(c);
                ++l;
            }
            ++i;
        }
        JDOMUtils.insertAfter(this.rows.get(stop - 1).getElement(), clones);
        this.readRows();
        i = start + count * (copies + 1);
        while (i < this.rows.size()) {
            Element r = this.rows.get(i).getElement();
            List children = r.getChildren("table-cell", r.getNamespace());
            for (Element element : children) {
                System.err.println("--------get table cell");
                List lChild = element.getChildren("frame", element.getNamespace("frame"));
                for (Element element2 : lChild) {
                    System.err.println("---------get frame");
                    Attribute attribute = element2.getAttribute("end-cell-address", r.getNamespace());
                    String value = attribute.getValue();
                    System.err.println(value);
                    Matcher matcher = regexp.matcher(value);
                    if (!matcher.matches() || matcher.groupCount() != 5) continue;
                    String result = matcher.group(1);
                    int val = Integer.parseInt(matcher.group(4));
                    result = String.valueOf(result) + (val += count * copies);
                    attribute.setValue(result);
                    System.err.println(attribute.getValue());
                }
            }
            ++i;
        }
        this.readRows();
    }

    private synchronized void addRow(Element child) {
        this.rows.add(new Row(this, child, this.rows.size()));
    }

    public final Point resolveHint(String ref) {
        Point res = Table.resolve(ref);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException(String.valueOf(ref) + " is not a cell ref, if it's a named range, you must use it on a SpreadSheet.");
    }

    public final boolean isCellValid(int x, int y) {
        if (x > this.getColumnCount()) {
            return false;
        }
        if (y > this.getRowCount()) {
            return false;
        }
        return this.getImmutableCellAt(x, y).isValid();
    }

    public final MutableCell<D> getCellAt(int x, int y) {
        return this.getRow(y).getMutableCellAt(x);
    }

    public final MutableCell<D> getCellAt(String ref) {
        return this.getCellAt(this.resolveHint(ref));
    }

    final MutableCell<D> getCellAt(Point p) {
        return this.getCellAt(p.x, p.y);
    }

    public final void setValueAt(Object val, int x, int y) {
        if (val == null) {
            val = "";
        }
        if (!val.equals(this.getValueAt(x, y))) {
            this.getCellAt(x, y).setValue(val);
        }
    }

    protected final Cell<D> getImmutableCellAt(int x, int y) {
        return this.getRow(y).getCellAt(x);
    }

    protected final Cell<D> getImmutableCellAt(String ref) {
        Point p = this.resolveHint(ref);
        return this.getImmutableCellAt(p.x, p.y);
    }

    public final Object getValueAt(int column, int row) {
        return this.getImmutableCellAt(column, row).getValue();
    }

    public final String getStyleNameAt(int column, int row) {
        String cellStyle = this.getImmutableCellAt(column, row).getStyleAttr();
        if (cellStyle != null) {
            return cellStyle;
        }
        cellStyle = this.getRow(row).getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
        if (cellStyle != null) {
            return cellStyle;
        }
        return this.getColumn(column).getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
    }

    public final CellStyle getStyleAt(int column, int row) {
        return (CellStyle)CellStyle.DESC.findStyle(this.getODDocument().getPackage(), this.getElement().getDocument(), this.getStyleNameAt(column, row));
    }

    public final List<Tuple2<Integer, Integer>> getStyleReferences(String cellStyleName) {
        ArrayList<Tuple2<Integer, Integer>> res = new ArrayList<Tuple2<Integer, Integer>>();
        HashSet<Integer> cols = new HashSet<Integer>();
        int columnCount = this.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            if (cellStyleName.equals(this.getColumn(i).getElement().getAttributeValue("default-cell-style-name", this.getTABLE()))) {
                cols.add(i);
            }
            ++i;
        }
        int rowCount = this.getRowCount();
        int y = 0;
        while (y < rowCount) {
            Row<D> row = this.getRow(y);
            String rowStyle = row.getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
            int x = 0;
            while (x < columnCount) {
                String cellStyle = row.getCellAt(x).getStyleAttr();
                boolean match = cellStyle != null ? cellStyleName.equals(cellStyle) : (rowStyle != null ? cellStyleName.equals(rowStyle) : cols.contains(x));
                if (match) {
                    res.add(Tuple2.create(x, y));
                }
                ++x;
            }
            ++y;
        }
        return res;
    }

    public final Object getValueAt(String ref) {
        return this.getImmutableCellAt(ref).getValue();
    }

    private Row<D> getRow(int index) {
        return this.rows.get(index);
    }

    public final Column<D> getColumn(int i) {
        return this.cols.get(i);
    }

    public final int getRowCount() {
        return this.rows.size();
    }

    public final int getHeaderRowCount() {
        return this.headerRowCount;
    }

    public final int getColumnCount() {
        return this.cols.size();
    }

    public final int getHeaderColumnCount() {
        return this.headerColumnCount;
    }

    public final void setColumnCount(int newSize) {
        this.setColumnCount(newSize, -1, false);
    }

    public final void ensureColumnCount(int newSize) {
        if (newSize > this.getColumnCount()) {
            this.setColumnCount(newSize);
        }
    }

    public final void setColumnCount(int newSize, int colIndex, boolean keepTableWidth) {
        int toGrow = newSize - this.getColumnCount();
        if (toGrow < 0) {
            this.removeColumn(newSize, this.getColumnCount(), keepTableWidth);
        } else if (toGrow > 0) {
            int indexOfLastCol = this.getColumnCount() == 0 ? this.getElement().getContentSize() - 1 : this.getElement().getContent().indexOf(this.getColumn(this.getColumnCount() - 1).getElement());
            Element elemToClone = colIndex < 0 ? Column.createEmpty(this.getODDocument().getVersion(), this.createDefaultColStyle()) : this.getColumn(colIndex).getElement();
            int i = 0;
            while (i < toGrow) {
                Element newElem = (Element)elemToClone.clone();
                this.getElement().addContent(indexOfLastCol + 1 + i, newElem);
                this.cols.add(new Column(this, newElem));
                ++i;
            }
            this.updateWidth(keepTableWidth);
            for (Row<D> r : this.rows) {
                r.columnCountChanged();
            }
        }
    }

    public final void removeColumn(int colIndex, boolean keepTableWidth) {
        this.removeColumn(colIndex, colIndex + 1, keepTableWidth);
    }

    public final void removeColumn(int firstIndex, int lastIndex, boolean keepTableWidth) {
        for (Row<D> r : this.rows) {
            r.checkRemove(firstIndex, lastIndex);
        }
        this.remove(true, firstIndex, lastIndex - 1);
        this.updateWidth(keepTableWidth);
        for (Row<D> r : this.rows) {
            r.removeCells(firstIndex, lastIndex);
        }
    }

    private void updateWidth(boolean keepTableWidth) {
        Float currentWidth = this.getWidth();
        float newWidth = 0.0f;
        Column<D> nullWidthCol = null;
        for (Column<D> col : this.cols) {
            Float colWidth = col.getWidth();
            if (colWidth != null) {
                assert (colWidth.floatValue() >= 0.0f);
                newWidth += colWidth.floatValue();
                continue;
            }
            newWidth = -1.0f;
            nullWidthCol = col;
            break;
        }
        if (keepTableWidth && currentWidth != null) {
            if (nullWidthCol != null) {
                throw new IllegalStateException("Cannot keep width since a column has no width : " + nullWidthCol);
            }
            float ratio = currentWidth.floatValue() / newWidth;
            HashSet<ColumnStyle> colStyles = new HashSet<ColumnStyle>();
            for (Column<D> col : this.cols) {
                colStyles.add((ColumnStyle)col.getStyle());
            }
            for (ColumnStyle colStyle : colStyles) {
                colStyle.setWidth(colStyle.getWidth().floatValue() * ratio);
            }
        } else {
            TableStyle style = (TableStyle)this.getStyle();
            if (style != null) {
                if (nullWidthCol != null) {
                    throw new IllegalStateException("Cannot update table width since a column has no width : " + nullWidthCol);
                }
                style.setWidth(newWidth);
            }
            for (Column<D> col : this.cols) {
                ColumnStyle colStyle = (ColumnStyle)col.getStyle();
                if (colStyle == null) continue;
                colStyle.rmRelWidth();
            }
        }
    }

    public final Float getWidth() {
        TableStyle style = (TableStyle)this.getStyle();
        return style == null ? null : style.getWidth();
    }

    private final ColumnStyle createDefaultColStyle() {
        ColumnStyle colStyle = (ColumnStyle)ColumnStyle.DESC.createAutoStyle(this.getODDocument().getPackage(), "defaultCol");
        colStyle.setWidth(20.0f);
        return colStyle;
    }

    private final void setCount(boolean col, int newSize) {
        this.remove(col, newSize, -1);
    }

    private final void remove(boolean col, int fromIndex, int toIndexIncl) {
        int toIndexValid;
        List<TableCalcNode> l = col ? this.cols : this.rows;
        int i = toIndexValid = CollectionUtils.getValidIndex(l, toIndexIncl);
        while (i >= fromIndex) {
            l.remove(i).getElement().detach();
            --i;
        }
    }

    public final void ensureRowCount(int newSize) {
        if (newSize > this.getRowCount()) {
            this.setRowCount(newSize);
        }
    }

    public final void setRowCount(int newSize) {
        this.setRowCount(newSize, -1);
    }

    public final void setRowCount(int newSize, int rowIndex) {
        Element elemToClone;
        if (rowIndex < 0) {
            elemToClone = Row.createEmpty(this.getODDocument().getVersion());
            elemToClone.addContent(Cell.createEmpty(this.getODDocument().getVersion(), this.getColumnCount()));
        } else {
            elemToClone = this.getRow(rowIndex).getElement();
        }
        int toGrow = newSize - this.getRowCount();
        if (toGrow < 0) {
            this.setCount(false, newSize);
        } else {
            int i = 0;
            while (i < toGrow) {
                Element newElem = (Element)elemToClone.clone();
                this.getElement().addContent(newElem);
                this.addRow(newElem);
                ++i;
            }
        }
    }

    public final SheetTableModel<D> getTableModel(int column, int row) {
        return new SheetTableModel(this, row, column);
    }

    public final SheetTableModel<D> getTableModel(int column, int row, int lastCol, int lastRow) {
        return new SheetTableModel(this, row, column, lastRow, lastCol);
    }

    public final SheetTableModel.MutableTableModel<D> getMutableTableModel(int column, int row) {
        return new SheetTableModel.MutableTableModel(this, row, column);
    }

    public final SheetTableModel.MutableTableModel<D> getMutableTableModel(Point start, Point end2) {
        return new SheetTableModel.MutableTableModel(this, start.y, start.x, end2.y + 1, end2.x + 1);
    }

    public final void merge(TableModel t, int column, int row) {
        this.merge(t, column, row, false);
    }

    public final void merge(TableModel t, int column, int row, boolean includeColNames) {
        int offset = includeColNames ? 1 : 0;
        this.ensureColumnCount(column + t.getColumnCount());
        this.ensureRowCount(row + t.getRowCount() + offset);
        SheetTableModel.MutableTableModel<D> thisModel = this.getMutableTableModel(column, row);
        if (includeColNames) {
            int x = 0;
            while (x < t.getColumnCount()) {
                thisModel.setValueAt(t.getColumnName(x), 0, x);
                ++x;
            }
        }
        int y = 0;
        while (y < t.getRowCount()) {
            int x = 0;
            while (x < t.getColumnCount()) {
                Object value = t.getValueAt(y, x);
                thisModel.setValueAt(value, y + offset, x);
                ++x;
            }
            ++y;
        }
    }

    public final Range getUsedRange() {
        return this.getUsedRange(false);
    }

    public final Range getUsedRange(boolean checkStyle) {
        int minX = -1;
        int minY = -1;
        int maxX = -1;
        int maxY = -1;
        int colCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        int x = 0;
        while (x < colCount) {
            int y = 0;
            while (y < rowCount) {
                if (!this.isCellBlank(x, y, checkStyle)) {
                    if (minX < 0 || x < minX) {
                        minX = x;
                    }
                    if (minY < 0 || y < minY) {
                        minY = y;
                    }
                    if (maxX < 0 || x > maxX) {
                        maxX = x;
                    }
                    if (maxY < 0 || y > maxY) {
                        maxY = y;
                    }
                }
                ++y;
            }
            ++x;
        }
        return minX < 0 ? null : new Range(this.getName(), new Point(minX, minY), new Point(maxX, maxY));
    }

    protected final boolean isCellBlank(int x, int y, boolean checkStyle) {
        if (!this.getImmutableCellAt(x, y).isEmpty()) {
            return false;
        }
        if (checkStyle) {
            CellStyle style = this.getStyleAt(x, y);
            return style == null || style.getBackgroundColor() == null && style.getTableCellProperties().getBorders().isEmpty();
        }
        return true;
    }

    public final Range getCurrentRegion(String ref) {
        return this.getCurrentRegion(ref, false);
    }

    public final Range getCurrentRegion(String ref, boolean checkStyle) {
        Point p = this.resolveHint(ref);
        return this.getCurrentRegion(p.x, p.y, checkStyle);
    }

    public final Range getCurrentRegion(int startX, int startY) {
        return this.getCurrentRegion(startX, startY, false);
    }

    public final Range getCurrentRegion(int startX, int startY, boolean checkStyle) {
        return new RegionExplorer(startX, startY, checkStyle).getCurrentRegion();
    }

    static final Point resolve(String ref) {
        Matcher matcher = SpreadSheet.minCellPattern.matcher(ref);
        if (!matcher.matches()) {
            return null;
        }
        return Table.resolve(matcher.group(1), matcher.group(2));
    }

    static final Point resolve(String letters, String digits) {
        return new Point(Table.toInt(letters), Integer.parseInt(digits) - 1);
    }

    static final int toInt(String col) {
        if (col.length() < 1) {
            throw new IllegalArgumentException("x cannot be empty");
        }
        col = col.toUpperCase();
        int x = 0;
        int i = 0;
        while (i < col.length()) {
            x = x * 26 + (col.charAt(i) - 65 + 1);
            ++i;
        }
        return x - 1;
    }

    static final String toStr(int col) {
        if (col < 0) {
            throw new IllegalArgumentException("negative column : " + col);
        }
        ++col;
        int radix = 26;
        StringBuilder chars = new StringBuilder(4);
        while (col > 0) {
            chars.append((char)(65 + (col - 1) % 26));
            col = (col - 1) / 26;
        }
        return chars.reverse().toString();
    }

    static final String getAddress(Point p) {
        if (p.x < 0 || p.y < 0) {
            throw new IllegalArgumentException("negative coordinates : " + p);
        }
        return String.valueOf(Table.toStr(p.x)) + (p.y + 1);
    }

    private class RegionExplorer {
        private final boolean checkStyle;
        private final int rowCount;
        private final int colCount;
        protected int minX;
        protected int minY;
        protected int maxX;
        protected int maxY;

        public RegionExplorer(int startX, int startY, boolean checkStyle) {
            this.rowCount = Table.this.getRowCount();
            this.colCount = Table.this.getColumnCount();
            this.minX = this.maxX = startX;
            this.minY = this.maxY = startY;
            this.checkStyle = checkStyle;
        }

        public boolean canXDecrement() {
            return this.minX > 0;
        }

        public boolean canYDecrement() {
            return this.minY > 0;
        }

        public boolean canXIncrement() {
            return this.maxX < this.colCount - 1;
        }

        public boolean canYIncrement() {
            return this.maxY < this.rowCount - 1;
        }

        private boolean checkRow(boolean upper) {
            if (upper && this.canYDecrement() || !upper && this.canYIncrement()) {
                int y = upper ? this.minY - 1 : this.maxY + 1;
                int start = this.canXDecrement() ? this.minX - 1 : this.minX;
                int stop = this.canXIncrement() ? this.maxX + 1 : this.maxX;
                int x = start;
                while (x <= stop) {
                    if (!Table.this.isCellBlank(x, y, this.checkStyle)) {
                        if (upper) {
                            this.minY = y;
                        } else {
                            this.maxY = y;
                        }
                        if (x < this.minX) {
                            this.minX = x;
                        }
                        if (x > this.maxX) {
                            this.maxX = x;
                        }
                        return true;
                    }
                    ++x;
                }
            }
            return false;
        }

        private boolean checkCol(boolean left) {
            if (left && this.canXDecrement() || !left && this.canXIncrement()) {
                int x = left ? this.minX - 1 : this.maxX + 1;
                int y = this.minY;
                while (y <= this.maxY) {
                    if (!Table.this.isCellBlank(x, y, this.checkStyle)) {
                        if (left) {
                            this.minX = x;
                        } else {
                            this.maxX = x;
                        }
                        return true;
                    }
                    ++y;
                }
            }
            return false;
        }

        private final boolean checkFrame() {
            return this.checkRow(true) || this.checkRow(false) || this.checkCol(true) || this.checkCol(false);
        }

        public final Range getCurrentRegion() {
            while (this.checkFrame()) {
            }
            return new Range(Table.this.getName(), new Point(this.minX, this.minY), new Point(this.maxX, this.maxY));
        }
    }
}

