/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.openconcerto.openoffice.ContentType;
import org.openconcerto.openoffice.ContentTypeVersioned;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.spreadsheet.Range;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SheetTableModel;
import org.openconcerto.openoffice.spreadsheet.Table;

public class SpreadSheet
implements ODDocument {
    private final ODPackage originalFile;
    private final Map<Element, Sheet> sheets;
    private static final String minCell = "\\$?([A-Z]+)\\$?([0-9]+)";
    static final Pattern cellPattern = Pattern.compile("(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?([A-Z]+)\\$?([0-9]+))");
    static final Pattern minCellPattern = Pattern.compile("\\$?([A-Z]+)\\$?([0-9]+)");
    static final Pattern cellRangePattern = Pattern.compile("(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?[A-Z]+\\$?[0-9]+)(:(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?[A-Z]+\\$?[0-9]+))?");

    public static SpreadSheet createFromFile(File f) throws IOException {
        return SpreadSheet.create(new ODPackage(f));
    }

    public static SpreadSheet create(ODPackage fd) {
        return new SpreadSheet(fd.getDocument(ODPackage.RootElement.CONTENT.getZipEntry()), fd.getDocument(ODPackage.RootElement.STYLES.getZipEntry()), fd);
    }

    public static SpreadSheet createEmpty(TableModel t) throws IOException {
        return SpreadSheet.createEmpty(t, XMLFormatVersion.getDefault());
    }

    public static SpreadSheet createEmpty(TableModel t, XMLFormatVersion ns) throws IOException {
        ContentTypeVersioned ct = ContentType.SPREADSHEET.getVersioned(ns.getXMLVersion());
        SpreadSheet spreadSheet = SpreadSheet.create(ct.createPackage(ns));
        spreadSheet.getBody().addContent(Sheet.createEmpty(ns.getXMLVersion()));
        spreadSheet.getSheet(0).merge(t, 0, 0, true);
        return spreadSheet;
    }

    public static File export(TableModel t, File f, XMLFormatVersion ns) throws IOException {
        return SpreadSheet.createEmpty(t, ns).saveAs(f);
    }

    public SpreadSheet(Document doc, Document styles) {
        this(doc, styles, null);
    }

    private SpreadSheet(Document doc, Document styles, ODPackage orig) {
        this.originalFile = orig != null ? orig : new ODPackage();
        this.originalFile.putFile("content.xml", doc);
        if (styles != null) {
            this.originalFile.putFile("styles.xml", styles);
        }
        this.sheets = new HashMap<Element, Sheet>();
    }

    final Document getContent() {
        return this.getPackage().getContent().getDocument();
    }

    @Override
    public final XMLVersion getVersion() {
        return this.getPackage().getVersion();
    }

    @Override
    public XMLFormatVersion getFormatVersion() {
        return this.getPackage().getFormatVersion();
    }

    private Element getBody() {
        return ContentType.SPREADSHEET.getVersioned(this.getVersion()).getBody(this.getContent());
    }

    protected static final String parseSheetName(String n) {
        if (n == null) {
            return null;
        }
        return n.charAt(0) == '$' ? n.substring(1) : n;
    }

    public final SheetTableModel.MutableTableModel<SpreadSheet> getTableModel(String name) {
        Element range;
        try {
            XPath path = this.getXPath("./table:named-expressions/table:named-range[@table:name='" + name + "']");
            range = (Element)path.selectSingleNode(this.getBody());
        }
        catch (JDOMException e) {
            throw new IllegalStateException(e);
        }
        if (range == null) {
            return null;
        }
        String baseCell = range.getAttributeValue("cell-range-address", this.getVersion().getTABLE());
        Range points = Range.parse(baseCell);
        if (points.spanSheets()) {
            throw new UnsupportedOperationException("different sheet names: " + points.getStartSheet() + " != " + points.getEndSheet());
        }
        Sheet sheet = this.getSheet(points.getStartSheet(), true);
        return sheet.getMutableTableModel(points.getStartPoint(), points.getEndPoint());
    }

    public final Cell<SpreadSheet> getCellAt(String ref) {
        Matcher m = cellPattern.matcher(ref);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.valueOf(ref) + " is not a valid cell address: " + m.pattern().pattern());
        }
        String sheetName = SpreadSheet.parseSheetName(m.group(1));
        if (sheetName == null) {
            throw new IllegalArgumentException("no sheet specified: " + ref);
        }
        return this.getSheet(sheetName, true).getCellAt(Sheet.resolve(m.group(5), m.group(6)));
    }

    public XPath getXPath(String p) throws JDOMException {
        return OOUtils.getXPath(p, this.getVersion());
    }

    private final List<Element> getTables() {
        return this.getBody().getChildren("table", this.getVersion().getTABLE());
    }

    public int getSheetCount() {
        return this.getTables().size();
    }

    public Sheet getSheet(int i) {
        return this.getSheet(this.getTables().get(i));
    }

    public Sheet getSheet(String name) {
        return this.getSheet(name, false);
    }

    public Sheet getSheet(String name, boolean mustExist) throws NoSuchElementException {
        for (Element table : this.getTables()) {
            if (!name.equals(Table.getName(table))) continue;
            return this.getSheet(table);
        }
        if (mustExist) {
            throw new NoSuchElementException("no such sheet: " + name);
        }
        return null;
    }

    private final Sheet getSheet(Element table) {
        Sheet res = this.sheets.get(table);
        if (res == null) {
            res = new Sheet(this, table);
            this.sheets.put(table, res);
        }
        return res;
    }

    void invalidate(Element element) {
        this.sheets.remove(element);
    }

    public final Sheet addSheet(int index, String name) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        Element newElem = Table.createEmpty(this.getVersion());
        return this.addSheet(index, newElem, name);
    }

    final Sheet addSheet(int index, Element newElem, String name) {
        this.getBody().addContent(this.getContentIndex(index), newElem);
        Sheet res = this.getSheet(newElem);
        if (name != null) {
            res.setName(name);
        }
        assert (res.getName() != null);
        return res;
    }

    private final int getContentIndex(int tableIndex) {
        if (tableIndex < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + tableIndex);
        }
        ArrayList<Element> tables = new ArrayList<Element>(this.getTables());
        if (tableIndex > tables.size()) {
            throw new IndexOutOfBoundsException("index (" + tableIndex + ") > count (" + tables.size() + ")");
        }
        int contentIndex = tableIndex == tables.size() ? this.getBody().indexOf((Content)tables.get(tableIndex - 1)) + 1 : this.getBody().indexOf((Content)tables.get(tableIndex));
        return contentIndex;
    }

    public final Sheet addSheet(String name) {
        return this.addSheet(this.getSheetCount(), name);
    }

    void move(Sheet sheet, int toIndex) {
        Element parentElement = sheet.getElement().getParentElement();
        sheet.getElement().detach();
        parentElement.addContent(this.getContentIndex(toIndex), sheet.getElement());
    }

    public File saveAs(File file) throws FileNotFoundException, IOException {
        this.getPackage().setFile(file);
        return this.getPackage().save();
    }

    @Override
    public final ODPackage getPackage() {
        return this.originalFile;
    }
}

