/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.RowStyle;
import org.openconcerto.openoffice.spreadsheet.Table;
import org.openconcerto.openoffice.spreadsheet.TableCalcNode;

public class Row<D extends ODDocument>
extends TableCalcNode<RowStyle, D> {
    private final Table<D> parent;
    private final int index;
    private final List<Cell<D>> cells;

    static Element createEmpty(XMLVersion ns) {
        return new Element("table-row", ns.getTABLE());
    }

    Row(Table<D> parent, Element tableRowElem, int index) {
        super(parent.getODDocument(), tableRowElem, RowStyle.class);
        this.parent = parent;
        this.index = index;
        this.cells = new ArrayList<Cell<D>>();
        for (Element cellElem : this.getCellElements()) {
            this.addCellElem(cellElem);
        }
    }

    protected final Table<D> getSheet() {
        return this.parent;
    }

    final int getY() {
        return this.index;
    }

    final int getX(MutableCell<D> c) {
        return this.cells.indexOf(c);
    }

    private void addCellElem(Element cellElem) {
        Cell cell = new Cell(this, cellElem);
        this.cells.add(cell);
        String repeatedS = cellElem.getAttributeValue("number-columns-repeated", this.getSheet().getTABLE());
        if (repeatedS != null) {
            int toRepeat = Integer.parseInt(repeatedS) - 1;
            int i = 0;
            while (i < toRepeat) {
                this.cells.add(cell);
                ++i;
            }
        }
    }

    private List<Element> getCellElements() {
        return this.getElement().getChildren();
    }

    protected final Cell<D> getCellAt(int col) {
        return this.cells.get(col);
    }

    protected final Cell<D> getValidCellAt(int col) {
        Cell<D> c = this.getCellAt(col);
        if (!c.isValid()) {
            throw new IllegalArgumentException("invalid cell " + c);
        }
        return c;
    }

    public final MutableCell<D> getMutableCellAt(int col) {
        Cell<D> c = this.getValidCellAt(col);
        if (!(c instanceof MutableCell)) {
            Element element = c.getElement();
            String repeatedS = element.getAttributeValue("number-columns-repeated", this.getSheet().getTABLE());
            if (repeatedS != null) {
                int repeated = Integer.parseInt(repeatedS);
                int firstIndex = this.cells.indexOf(c);
                int lastIndex = firstIndex + repeated - 1;
                int preRepeated = col - firstIndex;
                int postRepeated = lastIndex - col;
                this.casse(element, firstIndex, preRepeated, true);
                element.removeAttribute("number-columns-repeated", this.getSheet().getTABLE());
                this.casse(element, col + 1, postRepeated, false);
            }
            this.cells.set(col, new MutableCell(this, element));
        }
        return (MutableCell)this.getValidCellAt(col);
    }

    private final void casse(Element element, int firstIndex, int repeat2, boolean before) {
        if (repeat2 > 0) {
            Element newElem = (Element)element.clone();
            element.getParentElement().addContent(element.getParent().indexOf(element) + (before ? 0 : 1), newElem);
            newElem.setAttribute("number-columns-repeated", String.valueOf(repeat2), this.getSheet().getTABLE());
            Cell preCell = new Cell(this, newElem);
            int i = 0;
            while (i < repeat2) {
                this.cells.set(firstIndex + i, preCell);
                ++i;
            }
        }
    }

    void columnCountChanged() {
        int diff = this.getSheet().getColumnCount() - this.cells.size();
        if (diff < 0) {
            throw new IllegalStateException("should have used Table.removeColumn()");
        }
        if (diff > 0) {
            Element e = Cell.createEmpty(this.getSheet().getODDocument().getVersion(), diff);
            this.getElement().addContent(e);
            this.addCellElem(e);
        }
        if (this.cells.size() != this.getSheet().getColumnCount()) {
            throw new IllegalStateException();
        }
    }

    void checkRemove(int firstIndex, int lastIndexExcl) {
        if (lastIndexExcl > this.cells.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(lastIndexExcl) + " > " + this.cells.size());
        }
        if (!this.getCellAt(firstIndex).isValid()) {
            throw new IllegalArgumentException("unable to remove covered cell at " + firstIndex);
        }
    }

    void removeCells(int firstIndex, int lastIndexExcl) {
        this.checkRemove(firstIndex, lastIndexExcl);
        this.getMutableCellAt(firstIndex).unmerge();
        if (lastIndexExcl < this.cells.size()) {
            if (!this.getCellAt(lastIndexExcl - 1).isValid()) {
                int currentCol = lastIndexExcl - 2;
                while (!this.getCellAt(currentCol).isValid()) {
                    --currentCol;
                }
                this.getMutableCellAt(currentCol).unmerge();
            }
            this.getMutableCellAt(lastIndexExcl - 1).unmerge();
        }
        int i = firstIndex;
        while (i < lastIndexExcl) {
            this.cells.remove(firstIndex).getElement().detach();
            ++i;
        }
    }
}

