/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.awt.Point;
import java.util.regex.Matcher;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.openoffice.spreadsheet.Table;

public final class Range {
    private final String sheet1;
    private final String sheet2;
    private final Point start;
    private final Point end;

    public static final Range parse(String range) {
        Matcher m = SpreadSheet.cellRangePattern.matcher(range);
        if (!m.matches()) {
            throw new IllegalStateException(String.valueOf(range) + " is not a valid range address");
        }
        String sheet1 = SpreadSheet.parseSheetName(m.group(1));
        String sheet2 = SpreadSheet.parseSheetName(m.group(6));
        Point start = Table.resolve(m.group(4));
        Point end2 = Table.resolve(m.group(9));
        return new Range(sheet1, start, sheet2, end2);
    }

    public Range(String sheet, Point point) {
        this(sheet, point, point);
    }

    public Range(String sheet, Point startPoint, Point endPoint) {
        this(sheet, startPoint, null, endPoint);
    }

    public Range(String startSheet, Point startPoint, String endSheet, Point endPoint) {
        if (startSheet == null) {
            throw new NullPointerException("null sheet");
        }
        this.sheet1 = startSheet;
        this.sheet2 = endSheet == null ? startSheet : endSheet;
        this.start = startPoint;
        this.end = endPoint;
    }

    public final String getStartSheet() {
        return this.sheet1;
    }

    public final Point getStartPoint() {
        return this.start;
    }

    public final String getEndSheet() {
        return this.sheet2;
    }

    public final Point getEndPoint() {
        return this.end;
    }

    public final boolean spanSheets() {
        return !this.getStartSheet().equals(this.getEndSheet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range o = (Range)obj;
        return this.sheet1.equals(o.sheet1) && this.start.equals(o.start) && this.sheet2.equals(o.sheet2) && this.end.equals(o.end);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sheet1 == null ? 0 : this.sheet1.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (this.sheet2 == null ? 0 : this.sheet2.hashCode());
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getStartSheet());
        sb.append(".");
        sb.append(Table.getAddress(this.getStartPoint()));
        sb.append(":");
        if (this.spanSheets()) {
            sb.append(this.getEndSheet());
        }
        sb.append(".");
        sb.append(Table.getAddress(this.getEndPoint()));
        return sb.toString();
    }
}

