/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODFrame;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.spreadsheet.BytesProducer;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.spreadsheet.Row;
import org.openconcerto.utils.FileUtils;

public class MutableCell<D extends ODDocument>
extends Cell<D> {
    private static final DateFormat TextPDateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private static final NumberFormat TextPFloatFormat = new DecimalFormat(",##0.00");

    MutableCell(Row<D> parent, Element elem) {
        super(parent, elem);
    }

    public final int getX() {
        return this.getRow().getX(this);
    }

    public final int getY() {
        return this.getRow().getY();
    }

    private void setValueAttributes(ODValueType type, Object val) {
        if (type == null) {
            Attribute valueTypeAttr = this.getElement().getAttribute("value-type", this.getValueNS());
            if (valueTypeAttr != null) {
                valueTypeAttr.detach();
                this.getElement().removeAttribute(ODValueType.get(valueTypeAttr.getValue()).getValueAttribute(), this.getValueNS());
            }
        } else {
            this.getElement().setAttribute("value-type", type.getName(), this.getValueNS());
            this.getElement().setAttribute(type.getValueAttribute(), type.format(val), this.getValueNS());
        }
    }

    private void setTextP(String value) {
        if (value == null) {
            this.getElement().removeContent();
        } else {
            Element child = this.getElement().getChild("p", this.getNS().getTEXT());
            Element t = child != null ? child : new Element("p", this.getNS().getTEXT());
            t.setContent(new Text(value));
            this.getElement().setContent(t);
        }
    }

    private void setValue(ODValueType type, Object value, String textP) {
        this.setValueAttributes(type, value);
        this.setTextP(textP);
    }

    public void clearValue() {
        this.setValue(null, null, null);
    }

    public void setValue(Object obj) {
        if (obj instanceof Number) {
            if (obj instanceof Integer || obj instanceof Long) {
                this.setValue(ODValueType.FLOAT, obj, obj == null ? "" : obj.toString());
            } else {
                this.setValue(ODValueType.FLOAT, obj, TextPFloatFormat.format(obj));
            }
        } else if (obj instanceof Date) {
            this.setValue(ODValueType.DATE, obj, TextPDateFormat.format(obj));
        } else {
            this.setValue(null, null, obj.toString());
        }
    }

    public void replaceBy(String oldValue, String newValue) {
        this.replaceContentBy(this.getElement(), oldValue, newValue);
    }

    private void replaceContentBy(Element l, String oldValue, String newValue) {
        List content = l.getContent();
        int i = 0;
        while (i < content.size()) {
            Object obj = content.get(i);
            if (obj instanceof Text) {
                Text t = (Text)obj;
                t.setText(t.getText().replaceAll(oldValue, newValue));
            } else if (obj instanceof Element) {
                this.replaceContentBy((Element)obj, oldValue, newValue);
            }
            ++i;
        }
    }

    public final void unmerge() {
        int x = this.getX();
        int y = this.getY();
        int columnsSpanned = this.getColumnsSpanned();
        int rowsSpanned = this.getRowsSpanned();
        int i = 0;
        while (i < columnsSpanned) {
            int j = 0;
            while (j < rowsSpanned) {
                this.getRow().getSheet().getImmutableCellAt(x + i, y + j).getElement().setName("table-cell");
                ++j;
            }
            ++i;
        }
        this.getElement().removeAttribute("number-columns-spanned", this.getNS().getTABLE());
        this.getElement().removeAttribute("number-rows-spanned", this.getNS().getTABLE());
    }

    public final void merge(int columnsSpanned, int rowsSpanned) {
        boolean shrinks;
        int currentCols = this.getColumnsSpanned();
        int currentRows = this.getRowsSpanned();
        if (columnsSpanned == currentCols && rowsSpanned == currentRows) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        int i = 0;
        while (i < columnsSpanned) {
            int j = 0;
            while (j < rowsSpanned) {
                boolean coveredByThis;
                boolean bl = coveredByThis = i < currentCols && j < currentRows;
                if (!coveredByThis) {
                    int x2 = x + i;
                    int y2 = y + j;
                    Cell immutableCell = this.getRow().getSheet().getImmutableCellAt(x2, y2);
                    if (immutableCell.coversOtherCells()) {
                        throw new IllegalArgumentException("Cell at " + x2 + "," + y2 + " is a merged cell.");
                    }
                    if (immutableCell.getElement().getName().equals("covered-table-cell")) {
                        throw new IllegalArgumentException("Cell at " + x2 + "," + y2 + " is already covered.");
                    }
                }
                ++j;
            }
            ++i;
        }
        boolean bl = shrinks = columnsSpanned < currentCols || rowsSpanned < currentRows;
        if (shrinks) {
            this.unmerge();
        }
        int i2 = 0;
        while (i2 < columnsSpanned) {
            int j = 0;
            while (j < rowsSpanned) {
                boolean coveredByThis;
                boolean bl2 = coveredByThis = i2 < currentCols && j < currentRows;
                if (!(i2 == 0 && j == 0 || !shrinks && coveredByThis)) {
                    this.getRow().getSheet().getCellAt(x + i2, y + j).getElement().setName("covered-table-cell");
                }
                ++j;
            }
            ++i2;
        }
        this.getElement().setAttribute("number-columns-spanned", String.valueOf(columnsSpanned), this.getNS().getTABLE());
        this.getElement().setAttribute("number-rows-spanned", String.valueOf(rowsSpanned), this.getNS().getTABLE());
    }

    @Override
    public final String getStyleName() {
        return this.getRow().getSheet().getStyleNameAt(this.getX(), this.getY());
    }

    public void setImage(File pic) throws IOException {
        this.setImage(pic, false);
    }

    public void setImage(File pic, boolean keepRatio) throws IOException {
        this.setImage(pic.getName(), new BytesProducer.ByteArrayProducer(FileUtils.readBytes(pic), keepRatio));
    }

    public void setImage(String name, Image img) throws IOException {
        this.setImage(name, img == null ? null : new BytesProducer.ImageProducer(img, true));
    }

    private void setImage(String name, BytesProducer data) {
        Element imageElem;
        Namespace draw = this.getNS().getNS("draw");
        Element frame = this.getElement().getChild("frame", draw);
        Element element = imageElem = frame == null ? null : frame.getChild("image", draw);
        if (imageElem != null) {
            Attribute refAttr = imageElem.getAttribute("href", this.getNS().getNS("xlink"));
            this.getODDocument().getPackage().putFile(refAttr.getValue(), null);
            if (data == null) {
                frame.detach();
            } else {
                refAttr.setValue("Pictures/" + name + (data.getFormat() != null ? "." + data.getFormat() : ""));
                this.getODDocument().getPackage().putFile(refAttr.getValue(), data.getBytes(new ODFrame(this.getODDocument(), frame)));
            }
        } else if (data != null) {
            throw new IllegalStateException("this cell doesn't contain an image: " + this);
        }
    }

    public final void setBackgroundColor(Color color) {
        ((CellStyle)this.getPrivateStyle()).getTableCellProperties().setBackgroundColor(color);
    }
}

