/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import org.jdom.Element;
import org.openconcerto.openoffice.ODFrame;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.StyleStyle;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.TableStyle;

public class ColumnStyle
extends StyleStyle {
    public static final StyleStyleDesc<ColumnStyle> DESC = new StyleStyleDesc<ColumnStyle>(ColumnStyle.class, XMLVersion.OD, "table-column", "co", "table"){

        @Override
        public ColumnStyle create(ODPackage pkg, Element e) {
            return new ColumnStyle(pkg, e);
        }
    };

    public ColumnStyle(ODPackage pkg, Element tableColElem) {
        super(pkg, tableColElem);
    }

    public final Float getWidth() {
        String attr = this.getFormattingProperties().getAttributeValue("column-width", this.getSTYLE());
        return attr == null ? null : Float.valueOf(ODFrame.parseLength(attr, TableStyle.DEFAULT_UNIT));
    }

    public final String getBreakBefore() {
        return this.getFormattingProperties().getAttributeValue("break-before", this.getNS().getNS("fo"));
    }

    void setWidth(float f) {
        this.getFormattingProperties().setAttribute("column-width", String.valueOf(f) + TableStyle.DEFAULT_UNIT.getSymbol(), this.getSTYLE());
        this.rmRelWidth();
    }

    void rmRelWidth() {
        this.getFormattingProperties().removeAttribute("rel-column-width", this.getSTYLE());
    }
}

