/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jdom.Element;
import org.openconcerto.openoffice.ODFrame;
import org.openconcerto.utils.ImageInfo;
import org.openconcerto.utils.ImageUtils;

abstract class BytesProducer {
    BytesProducer() {
    }

    abstract byte[] getBytes(ODFrame<?> var1);

    abstract String getFormat();

    static final class ByteArrayProducer
    extends BytesProducer {
        private final byte[] data;
        private final boolean keepRatio;

        public ByteArrayProducer(byte[] data) {
            this(data, false);
        }

        public ByteArrayProducer(byte[] data, boolean keepRatio) {
            this.data = data;
            this.keepRatio = keepRatio;
        }

        @Override
        public byte[] getBytes(ODFrame<?> frame) {
            if (this.keepRatio) {
                double ratio;
                ImageInfo info = new ImageInfo();
                info.setInput(new ByteArrayInputStream(this.data));
                if (!info.check()) {
                    throw new IllegalStateException("unable to parse the picture");
                }
                double imgRatio = (double)info.getWidth() / (double)info.getHeight();
                if (imgRatio > (ratio = frame.getRatio())) {
                    double newFrameHeight = frame.getWidth().doubleValue() / imgRatio;
                    double diff = frame.getHeight().doubleValue() - newFrameHeight;
                    frame.setSVGAttr("y", frame.getY().doubleValue() + diff / 2.0);
                    frame.setSVGAttr("height", newFrameHeight);
                } else {
                    double newFrameWidth = frame.getHeight().doubleValue() * imgRatio;
                    double diff = frame.getWidth().doubleValue() - newFrameWidth;
                    frame.setSVGAttr("x", frame.getX().doubleValue() + diff / 2.0);
                    frame.setSVGAttr("width", newFrameWidth);
                }
                Element frameElem = frame.getElement();
                frameElem.removeAttribute("end-cell-address", frameElem.getNamespace("table"));
                frameElem.removeAttribute("end-x", frameElem.getNamespace("table"));
                frameElem.removeAttribute("end-y", frameElem.getNamespace("table"));
            }
            return this.data;
        }

        @Override
        public String getFormat() {
            return null;
        }
    }

    static final class ImageProducer
    extends BytesProducer {
        private final Image img;
        private final boolean keepRatio;

        public ImageProducer(Image img, boolean keepRatio) {
            this.img = img;
            this.keepRatio = keepRatio;
        }

        @Override
        public byte[] getBytes(ODFrame<?> frame) {
            BufferedImage bImg;
            if (this.keepRatio) {
                float ratio = (float)frame.getRatio();
                bImg = ImageUtils.createQualityResizedImage(this.img, ratio, true, Color.WHITE, true);
            } else {
                bImg = ImageUtils.createQualityResizedImage(this.img, this.img.getWidth(null), this.img.getHeight(null), true, true, Color.WHITE, true);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(0x100000);
            try {
                ImageIO.write((RenderedImage)bImg, this.getFormat(), out);
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to export " + bImg + " to " + this.getFormat());
            }
            return out.toByteArray();
        }

        @Override
        public String getFormat() {
            return "png";
        }
    }
}

