/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.generation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import org.openconcerto.openoffice.Log;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.openoffice.generation.DocumentGenerator;
import org.openconcerto.openoffice.generation.StatusListener;
import org.openconcerto.openoffice.generation.TaskStatus;

public final class GenerationTask {
    private final String name;
    private final DocumentGenerator generator;
    private final PropertyChangeSupport changeSupport;
    private TaskStatus status;

    public GenerationTask(String name, DocumentGenerator generator) {
        this.name = name;
        this.generator = generator;
        this.status = TaskStatus.NOT_STARTED;
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public ODSingleXMLDocument generate() throws IOException, InterruptedException {
        boolean willGenerate;
        try {
            willGenerate = this.generator.willGenerate();
        }
        catch (Exception exn) {
            throw new IOException("Erreur willGenerate", exn);
        }
        if (willGenerate) {
            this.setStatus(TaskStatus.STARTED);
            this.generator.setStatusListener(new StatusListener(){

                @Override
                public void statusChanged(int percent) {
                    GenerationTask.this.setCompletion((float)percent / 100.0f);
                }
            });
            Log.get().fine(this + " begun");
            ODSingleXMLDocument res = this.generator.generate();
            Log.get().fine(this + " done");
            this.generator.setStatusListener(null);
            this.setStatus(TaskStatus.DONE);
            return res;
        }
        return null;
    }

    private void setStatus(TaskStatus status) {
        if (status != this.status) {
            TaskStatus old = this.status;
            this.status = status;
            this.changeSupport.firePropertyChange("status", old, this.status);
        }
    }

    private void setCompletion(float completion) {
        this.setStatus(TaskStatus.create(completion));
    }

    public final TaskStatus getStatus() {
        return this.status;
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.getStatus();
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected final DocumentGenerator getGenerator() {
        return this.generator;
    }

    public final String getName() {
        return this.name;
    }
}

