/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.generation;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.openoffice.OOXML;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.generation.DocumentGenerator;
import org.openconcerto.openoffice.generation.ReportGeneration;
import org.openconcerto.openoffice.generation.desc.part.GeneratorReportPart;
import org.openconcerto.openoffice.generation.generator.ExtractGenerator;

public class GenerationCommon<R extends ReportGeneration<?>> {
    private static final NumberFormat FLOAT_FMT = new DecimalFormat("#.###");
    private final R rg;
    private OOXML xml;

    public GenerationCommon(R rg) {
        this.rg = rg;
        this.xml = null;
    }

    public final XMLVersion getOOVersion() {
        return this.getOOXML().getVersion();
    }

    public final OOXML getOOXML() {
        if (this.xml == null) {
            try {
                this.xml = new ODPackage(((ReportGeneration)this.getRg()).getReportType().getTemplate()).getFormatVersion().getXML();
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't read template", e);
            }
        }
        return this.xml;
    }

    protected final Element encodeRT(String s) {
        return this.getOOXML().encodeRT(s, this.getStyleMap());
    }

    protected Map<String, String> getStyleMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("b", "Gras");
        m.put("i", "Italique");
        return m;
    }

    public final Element encode(String s) {
        return this.getOOXML().encodeWS(this.encodeRT(s));
    }

    public final Element encodeNoRT(String s) {
        return this.getOOXML().encodeWS(s);
    }

    public final String formatNonZero(Number n) {
        return n.intValue() == 0 ? "" : String.valueOf(n.intValue());
    }

    public final String formatNonZeroFloat(Number n) {
        return n.floatValue() == 0.0f ? "" : FLOAT_FMT.format(n.floatValue());
    }

    protected final R getRg() {
        return this.rg;
    }

    protected DocumentGenerator<R> getStyleTemplateGenerator(File f) {
        return null;
    }

    protected DocumentGenerator<R> createGenerator(GeneratorReportPart part) {
        File f = ((ReportGeneration)this.getRg()).getReportType().getParent().resolve(part.getElem().getAttributeValue("file"));
        return new ExtractGenerator<R>(this.getRg(), f);
    }

    protected void preProcessDocument(ODSingleXMLDocument doc) {
    }
}

