/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import org.jdom.Document;
import org.jdom.Element;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODNode;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.Style;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.XMLVersion;

public abstract class StyledNode<S extends Style, D extends ODDocument>
extends ODNode {
    private final StyleDesc<S> styleClass;

    public StyledNode(Element local, Class<S> styleClass) {
        super(local);
        if (styleClass == null) {
            throw new NullPointerException("null style class");
        }
        this.styleClass = Style.getStyleDesc(styleClass, XMLVersion.getVersion(this.getElement()));
        assert (this.styleClass.getRefElements().contains(this.getElement().getQualifiedName())) : String.valueOf(this.getElement().getQualifiedName()) + " not in " + this.styleClass;
    }

    public abstract D getODDocument();

    public final S getStyle() {
        D doc = this.getODDocument();
        return doc == null ? null : (S)this.getStyle(doc.getPackage(), this.getElement().getDocument());
    }

    protected final S getStyle(ODPackage pkg, Document doc) {
        return this.styleClass.findStyle(pkg, doc, this.getStyleName());
    }

    public final S getPrivateStyle() {
        S currentStyle = this.getStyle();
        if (currentStyle != null && ((Style)currentStyle).isReferencedAtMostOnce()) {
            return currentStyle;
        }
        Object newStyle = currentStyle == null ? this.styleClass.createAutoStyle(this.getODDocument().getPackage()) : (Style)this.styleClass.getStyleClass().cast(((Style)currentStyle).dup());
        this.setStyleName(((Style)newStyle).getName());
        assert (((Style)this.getStyle()).equals(newStyle));
        return (S)newStyle;
    }

    protected String getStyleName() {
        return this.getElement().getAttributeValue("style-name", this.getElement().getNamespace());
    }

    public final void setStyleName(String name) {
        this.getElement().setAttribute("style-name", name, this.getElement().getNamespace());
    }
}

