/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.awt.Color;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.Style;

public abstract class StyleProperties {
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    public static final String TRANSPARENT_NAME = "transparent";
    private final Style parentStyle;
    private final String propPrefix;

    public StyleProperties(Style style, String propPrefix) {
        this.parentStyle = style;
        this.propPrefix = propPrefix;
    }

    public final Style getParentStyle() {
        return this.parentStyle;
    }

    public final Element getElement() {
        return this.getParentStyle().getFormattingProperties(this.propPrefix);
    }

    protected final boolean parseBoolean(String s, boolean def) {
        return s == null ? def : Boolean.parseBoolean(s);
    }

    protected final Namespace getNS(String prefix) {
        return this.getParentStyle().getNS().getNS(prefix);
    }

    public final String getRawBackgroundColor() {
        return this.getElement().getAttributeValue("background-color", this.getNS("fo"));
    }

    public final Color getBackgroundColor() {
        String res = this.getRawBackgroundColor();
        if (res == null) {
            return null;
        }
        if (TRANSPARENT_NAME.equals(res)) {
            return TRANSPARENT;
        }
        return OOUtils.decodeRGB(res);
    }

    public final void setBackgroundColor(Color color) {
        this.setBackgroundColor(color.getAlpha() == TRANSPARENT.getAlpha() ? TRANSPARENT_NAME : OOUtils.encodeRGB(color));
    }

    public final void setBackgroundColor(String color) {
        this.getElement().setAttribute("background-color", color, this.getNS("fo"));
    }
}

