/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.Format;
import java.text.SimpleDateFormat;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.FormatGroup;
import org.openconcerto.utils.XMLDateFormat;
import org.openconcerto.xml.JDOMUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class OOUtils {
    public static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("'PT'HH'H'mm'M'ss'S'");
    public static final Format DATE_FORMAT = new FormatGroup(new XMLDateFormat(), new SimpleDateFormat("yyyy-MM-dd'T'HH':'mm':'ss"), new SimpleDateFormat("yyyy-MM-dd"));
    private static final String[] executables = new String[]{"ooffice2", "ooffice", "soffice"};

    public static void open(File f) throws IOException {
        FileUtils.open(f, executables);
    }

    public static SAXBuilder getBuilder() {
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId.endsWith(".dtd")) {
                    InputSource in = new InputSource();
                    in.setCharacterStream(new StringReader(""));
                    return in;
                }
                return null;
            }
        });
        return builder;
    }

    public static SAXBuilder getBuilderLoadDTD() {
        SAXBuilder builder = new SAXBuilder(){

            @Override
            public Document build(InputSource in) throws JDOMException, IOException {
                in.setSystemId(OOUtils.class.getResource("oofficeDTDs/").toExternalForm());
                return super.build(in);
            }
        };
        return builder;
    }

    public static Document parseDocument(String doc) throws JDOMException {
        return JDOMUtils.parseStringDocument(doc, OOUtils.getBuilder());
    }

    public static final XPath getXPath(String path, XMLVersion version) throws JDOMException {
        XPath xp = XPath.newInstance(path);
        Namespace[] namespaceArray = version.getALL();
        int n = namespaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Namespace ns = namespaceArray[n2];
            xp.addNamespace(ns);
            ++n2;
        }
        return xp;
    }

    public static String encodeRGB(Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
    }

    public static Color decodeRGB(String color) {
        return color == null ? null : Color.decode(color.trim());
    }
}

