/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.xml.JDOMUtils;

public class OOHandGeneratedXMLDocument
extends ODSingleXMLDocument {
    public static OOHandGeneratedXMLDocument create(Element[] elements) {
        XMLVersion ooVersion = XMLVersion.OOo;
        Element root = new Element("document-content", ooVersion.getOFFICE());
        root.setAttribute("class", "text", ooVersion.getOFFICE());
        root.setAttribute("version", "1.0", ooVersion.getOFFICE());
        boolean hasBody = false;
        int i = 0;
        while (i < elements.length) {
            Element elem = elements[i];
            root.addContent(elem);
            hasBody = !hasBody && elem.getName().equals("body");
            ++i;
        }
        if (!hasBody) {
            throw new IllegalArgumentException("you must specify a body.");
        }
        return new OOHandGeneratedXMLDocument(new Document(root));
    }

    public static OOHandGeneratedXMLDocument create(String body) throws JDOMException, IOException {
        Document stylesDoc = OOUtils.getBuilder().build(OOHandGeneratedXMLDocument.class.getResource("handAutoStyles.xml"));
        return OOHandGeneratedXMLDocument.create(stylesDoc.detachRootElement(), JDOMUtils.parseElementString("<office:body>" + body + "</office:body>", XMLVersion.getOOo().getALL()));
    }

    private static OOHandGeneratedXMLDocument create(Element autoStyles, Element body) {
        return OOHandGeneratedXMLDocument.create(new Element[]{autoStyles, body});
    }

    private OOHandGeneratedXMLDocument(Document content) {
        super(content);
    }
}

