/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.openconcerto.openoffice.OOUtils;

public enum ODValueType {
    FLOAT("value", new Class[]{Number.class}){

        @Override
        public String format(Object o) {
            if (o instanceof BigDecimal) {
                return ((BigDecimal)o).toPlainString();
            }
            return ((Number)o).toString();
        }

        @Override
        public BigDecimal parse(String s) {
            return new BigDecimal(s);
        }
    }
    ,
    PERCENTAGE("value", new Class[]{Number.class}){

        @Override
        public String format(Object o) {
            return FLOAT.format(o);
        }

        @Override
        public Object parse(String s) {
            return FLOAT.parse(s);
        }
    }
    ,
    CURRENCY("value", new Class[]{Number.class}){

        @Override
        public String format(Object o) {
            return FLOAT.format(o);
        }

        @Override
        public Object parse(String s) {
            return FLOAT.parse(s);
        }
    }
    ,
    DATE("date-value", new Class[]{Date.class, Calendar.class}){

        @Override
        public String format(Object o) {
            Date d = o instanceof Calendar ? ((Calendar)o).getTime() : (Date)o;
            return OOUtils.DATE_FORMAT.format(d);
        }

        @Override
        public Date parse(String date) {
            if (date.length() == 0) {
                return null;
            }
            try {
                return (Date)OOUtils.DATE_FORMAT.parseObject(date);
            }
            catch (ParseException e) {
                throw new IllegalStateException("wrong date: " + date, e);
            }
        }
    }
    ,
    TIME("time-value", new Class[]{Calendar.class}){

        @Override
        public String format(Object o) {
            Calendar cal = (Calendar)o;
            SimpleDateFormat fmt = (SimpleDateFormat)OOUtils.TIME_FORMAT.clone();
            fmt.setTimeZone(cal.getTimeZone());
            return fmt.format(cal.getTime());
        }

        @Override
        public Calendar parse(String date) {
            if (date.length() == 0) {
                return null;
            }
            Calendar cal = (Calendar)OOUtils.TIME_FORMAT.getCalendar().clone();
            try {
                cal.setTime((Date)OOUtils.TIME_FORMAT.parseObject(date));
            }
            catch (ParseException e) {
                throw new IllegalStateException("wrong date: " + date, e);
            }
            return cal;
        }
    }
    ,
    BOOLEAN("boolean-value", new Class[]{Boolean.class}){

        @Override
        public String format(Object o) {
            return ((Boolean)o).toString().toLowerCase();
        }

        @Override
        public Boolean parse(String s) {
            return Boolean.valueOf(s);
        }
    }
    ,
    STRING("string-value", new Class[]{String.class}){

        @Override
        public String format(Object o) {
            return o.toString();
        }

        @Override
        public String parse(String s) {
            return s;
        }
    };

    private final String attr;
    private final List<Class<?>> acceptedClasses;

    private ODValueType(String attr, Class<?> ... classes) {
        this.attr = attr;
        this.acceptedClasses = Arrays.asList(classes);
    }

    public final String getValueAttribute() {
        return this.attr;
    }

    public boolean canFormat(Class<?> toFormat) {
        for (Class<?> c : this.acceptedClasses) {
            if (!c.isAssignableFrom(toFormat)) continue;
            return true;
        }
        return false;
    }

    public abstract String format(Object var1);

    public abstract Object parse(String var1);

    public final String getName() {
        return this.name().toLowerCase();
    }

    public static ODValueType get(String name) {
        return ODValueType.valueOf(name.toUpperCase());
    }

    public static ODValueType forObject(Object o) {
        if (o instanceof Number) {
            return FLOAT;
        }
        if (o instanceof Boolean) {
            return BOOLEAN;
        }
        if (o instanceof String) {
            return STRING;
        }
        if (o instanceof Calendar && !((Calendar)o).isSet(5)) {
            return TIME;
        }
        if (DATE.canFormat(o.getClass())) {
            return DATE;
        }
        return null;
    }

    /* synthetic */ ODValueType(String string, int n, String string2, Class[] classArray, ODValueType oDValueType) {
        this(string2, classArray);
    }
}

