/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.ODNode;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.ODXMLDocument;
import org.openconcerto.openoffice.XMLVersion;

public class ODUserDefinedMeta
extends ODNode {
    private static final String ELEM_NAME = "user-defined";
    private static final EnumSet<ODValueType> allowedTypes = EnumSet.of(ODValueType.FLOAT, ODValueType.DATE, ODValueType.TIME, ODValueType.BOOLEAN, ODValueType.STRING);
    private final ODXMLDocument parent;

    static ODUserDefinedMeta create(String name, ODXMLDocument parent) {
        Element elem = new Element(ELEM_NAME, parent.getVersion().getMETA());
        elem.setAttribute("name", name, parent.getVersion().getMETA());
        ODUserDefinedMeta res = new ODUserDefinedMeta(elem, parent);
        res.setValue("");
        return res;
    }

    private static List<Element> getChildren(Element metaElem, Namespace metaNS) {
        return metaElem.getChildren(ELEM_NAME, metaNS);
    }

    static Element getElement(Element metaElem, String name, XMLVersion ns) {
        Namespace metaNS = ns.getMETA();
        for (Element elem : ODUserDefinedMeta.getChildren(metaElem, metaNS)) {
            if (!name.equals(elem.getAttributeValue("name", metaNS))) continue;
            return elem;
        }
        return null;
    }

    static List<String> getNames(Element metaElem, XMLVersion ns) {
        Namespace metaNS = ns.getMETA();
        ArrayList<String> res = new ArrayList<String>();
        for (Element elem : ODUserDefinedMeta.getChildren(metaElem, metaNS)) {
            res.add(elem.getAttributeValue("name", metaNS));
        }
        return res;
    }

    ODUserDefinedMeta(Element elem, ODXMLDocument parent) {
        super(elem);
        this.parent = parent;
    }

    protected final ODXMLDocument getParent() {
        return this.parent;
    }

    public final String getName() {
        return this.getElement().getAttributeValue("name", this.getNS().getMETA());
    }

    private final XMLVersion getNS() {
        return this.getParent().getVersion();
    }

    private final Attribute getValueTypeAttr() {
        return this.getValueTypeAttr(true);
    }

    private final Attribute getValueTypeAttr(boolean create) {
        Attribute res = this.getElement().getAttribute("value-type", this.getNS().getMETA());
        if (res == null && create) {
            res = new Attribute("value-type", ODValueType.STRING.getName(), this.getNS().getMETA());
            this.getElement().setAttribute(res);
        }
        return res;
    }

    public final Object getValue() {
        return this.getValueType().parse(this.getElement().getTextTrim());
    }

    public final ODValueType getValueType() {
        return ODValueType.get(this.getValueTypeAttr().getValue());
    }

    public final void setValue(Object o) {
        this.setValue(o, ODValueType.forObject(o));
    }

    public final void setValue(Object o, ODValueType vt) {
        if (!allowedTypes.contains((Object)vt)) {
            throw new IllegalArgumentException((Object)((Object)vt) + " is not allowed: " + allowedTypes);
        }
        if (vt != ODValueType.STRING) {
            this.getValueTypeAttr().setValue(vt.getName());
        } else {
            Attribute attr = this.getValueTypeAttr(false);
            if (attr != null) {
                attr.detach();
            }
        }
        this.getElement().setText(vt.format(o));
    }
}

