/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.openconcerto.openoffice.ContentType;
import org.openconcerto.openoffice.ContentTypeVersioned;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODMeta;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODPackageEntry;
import org.openconcerto.openoffice.ODUserDefinedMeta;
import org.openconcerto.openoffice.ODXMLDocument;
import org.openconcerto.openoffice.Style;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.text.TextNode;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CopyUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.xml.JDOMUtils;
import org.openconcerto.xml.SimpleXMLPath;
import org.openconcerto.xml.Step;

public class ODSingleXMLDocument
extends ODXMLDocument
implements Cloneable,
ODDocument {
    static final Set<String> DONT_PREFIX = new HashSet<String>();
    private static final String COUNT = "SingleXMLDocument_count";
    private int numero;
    private final Set<String> stylesNames;
    private final Set<String> listStylesNames;
    private ODPackage pkg;
    private final ODMeta meta;
    private Element pageBreak;
    private final ODXMLDocument.ElementTransformer prefixTransf = new ODXMLDocument.ElementTransformer(){

        @Override
        public Element transform(Element elem) throws JDOMException {
            ODSingleXMLDocument.this.prefix(elem, true);
            return elem;
        }
    };
    private final ODXMLDocument.ElementTransformer prefixTransfNoRef = new ODXMLDocument.ElementTransformer(){

        @Override
        public Element transform(Element elem) throws JDOMException {
            ODSingleXMLDocument.this.prefix(elem, false);
            return elem;
        }
    };

    static {
        DONT_PREFIX.add("user-field-decl");
        DONT_PREFIX.add("user-field-get");
        DONT_PREFIX.add("variable-get");
        DONT_PREFIX.add("variable-decl");
        DONT_PREFIX.add("variable-set");
    }

    public static ODSingleXMLDocument createFromDocument(Document content, Document style) {
        return ODSingleXMLDocument.createFromDocument(content, style, null);
    }

    public static ODSingleXMLDocument createFromDocument(Document content, Document style, Document settings) {
        return ODSingleXMLDocument.createFromDocument(content, style, settings, null, new ODPackage());
    }

    static ODSingleXMLDocument createFromDocument(Document content, Document style, Document settings, Document meta, ODPackage files) {
        Document singleContent = ODPackage.RootElement.createSingle(content);
        ODSingleXMLDocument.copyNS(content, singleContent);
        files.getContentType().setType(singleContent);
        Element root = singleContent.getRootElement();
        root.addContent(content.getRootElement().removeContent());
        ODSingleXMLDocument.prependToRoot(settings, root);
        ODSingleXMLDocument.prependToRoot(meta, root);
        ODSingleXMLDocument single = new ODSingleXMLDocument(singleContent, files);
        if (single.getChild("body") == null) {
            throw new IllegalArgumentException("no body in " + single);
        }
        if (style != null) {
            try {
                single.mergeAllStyles(new ODXMLDocument(style), true);
            }
            catch (JDOMException e) {
                throw new IllegalArgumentException("style is not valid", e);
            }
        }
        return single;
    }

    private static void prependToRoot(Document settings, Element root) {
        if (settings != null) {
            ODSingleXMLDocument.copyNS(settings, root.getDocument());
            Element officeSettings = (Element)settings.getRootElement().getChildren().get(0);
            root.addContent(0, (Element)officeSettings.clone());
        }
    }

    private static void copyNS(Document src, Document dest) {
        JDOMUtils.addNamespaces(dest.getRootElement(), src.getRootElement().getAdditionalNamespaces());
    }

    public static ODSingleXMLDocument createFromFile(File f) throws JDOMException, IOException {
        return new ODPackage(f).toSingle();
    }

    public ODSingleXMLDocument(Document content) {
        this(content, new ODPackage());
    }

    private ODSingleXMLDocument(Document content, ODPackage pkg) {
        super(content);
        this.pageBreak = null;
        this.pkg = pkg;
        for (ODPackage.RootElement e : ODPackage.RootElement.getPackageElements()) {
            this.pkg.rmFile(e.getZipEntry());
        }
        this.pkg.putFile(ODPackage.RootElement.CONTENT.getZipEntry(), this, "text/xml");
        this.getChild("meta", true);
        Properties props = ProductInfo.getInstance().getProps();
        String generator = props == null ? this.getClass().getName() : String.valueOf(props.getProperty("NAME")) + "/" + props.getProperty("VERSION");
        this.meta = ODMeta.create(this);
        this.meta.setGenerator(generator);
        ODUserDefinedMeta userMeta = this.meta.getUserMeta(COUNT);
        if (userMeta != null) {
            Object countValue = userMeta.getValue();
            this.numero = countValue instanceof Number ? ((Number)countValue).intValue() : new BigDecimal(countValue.toString()).intValue();
        } else {
            this.setNumero(0);
        }
        this.stylesNames = new HashSet<String>(64);
        this.listStylesNames = new HashSet<String>(16);
        Element styles = this.getChild("styles");
        if (styles != null) {
            Element root = this.getDocument().getRootElement();
            Document clonedDoc = new Document(new Element(root.getName(), root.getNamespace()));
            clonedDoc.getRootElement().addContent(styles.detach());
            try {
                this.mergeStyles(new ODXMLDocument(clonedDoc));
            }
            catch (JDOMException e) {
                throw new IllegalArgumentException("can't find common styles names.");
            }
            styles.detach();
            this.setChild(styles);
        }
    }

    ODSingleXMLDocument(ODSingleXMLDocument doc, ODPackage p) {
        super(doc);
        if (p == null) {
            throw new NullPointerException("Null package");
        }
        this.stylesNames = new HashSet<String>(doc.stylesNames);
        this.listStylesNames = new HashSet<String>(doc.listStylesNames);
        this.pkg = p;
        this.meta = ODMeta.create(this);
        this.setNumero(doc.numero);
    }

    public ODSingleXMLDocument clone() {
        ODPackage copy2 = new ODPackage(this.pkg);
        return (ODSingleXMLDocument)copy2.getContent();
    }

    private void setNumero(int numero) {
        this.numero = numero;
        this.meta.getUserMeta(COUNT, true).setValue(this.numero);
    }

    public final int getNumero() {
        return this.numero;
    }

    @Override
    public ODPackage getPackage() {
        return this.pkg;
    }

    public synchronized void add(TextNode p) {
        this.add(p, null, -1);
    }

    public synchronized void add(TextNode p, Element where, int index) {
        Element addToElem;
        Element element = addToElem = where == null ? this.getBody() : where;
        if (index < 0) {
            addToElem.addContent(p.getElement());
        } else {
            addToElem.addContent(index, p.getElement());
        }
        try {
            p.setDocument(this);
        }
        catch (RuntimeException e) {
            p.getElement().detach();
            throw e;
        }
    }

    public synchronized void add(ODSingleXMLDocument doc) {
        this.add(doc, true);
    }

    public synchronized void add(ODSingleXMLDocument doc, boolean pageBreak) {
        if (doc != null && pageBreak) {
            this.getBody().addContent(this.getPageBreak());
        }
        this.add(null, 0, doc);
    }

    public synchronized void replace(Element elem, ODSingleXMLDocument doc) {
        Element parent = elem.getParentElement();
        this.add(parent, parent.indexOf(elem), doc);
        elem.detach();
    }

    public synchronized void add(Element where, int index, ODSingleXMLDocument doc) {
        if (doc == null) {
            return;
        }
        if (!this.getVersion().equals((Object)doc.getVersion())) {
            throw new IllegalArgumentException("version mismatch");
        }
        this.setNumero(this.numero + 1);
        try {
            ODSingleXMLDocument.copyNS(doc.getDocument(), this.getDocument());
            this.mergeEmbedded(doc);
            this.mergeSettings(doc);
            this.mergeAllStyles(doc, false);
            this.mergeBody(where, index, doc);
        }
        catch (JDOMException exn) {
            throw new IllegalArgumentException("XML error", exn);
        }
    }

    private void mergeAllStyles(ODXMLDocument doc, boolean sameDoc) throws JDOMException {
        this.mergeFontDecls(doc);
        this.mergeStyles(doc);
        this.mergeAutoStyles(doc, !sameDoc);
        this.mergeMasterStyles(doc, !sameDoc);
    }

    private void mergeEmbedded(ODSingleXMLDocument doc) {
        this.pkg.rmFile("Thumbnails/thumbnail.png");
        ODPackage opkg = CopyUtils.copy(doc.pkg);
        for (String name : opkg.getEntries()) {
            ODPackageEntry e = opkg.getEntry(name);
            if (ODPackage.isStandardFile(e.getName())) continue;
            this.pkg.putFile(this.prefix(e.getName()), e.getData(), e.getType());
        }
    }

    private void mergeSettings(ODSingleXMLDocument doc) throws JDOMException {
        this.addIfNotPresent(doc, "./office:settings", 0);
    }

    private void mergeFontDecls(ODXMLDocument doc) throws JDOMException {
        String[] fontDecls = this.getFontDecls();
        this.mergeUnique(doc, fontDecls[0], fontDecls[1]);
    }

    private String[] getFontDecls() {
        return this.getXML().getFontDecls();
    }

    private void mergeStyles(ODXMLDocument doc) throws JDOMException {
        this.mergeUnique(doc, "styles", "style:default-style", "style:family", NOP_ElementTransformer);
        this.stylesNames.addAll(this.mergeUnique(doc, "styles", "style:style"));
        this.addStylesIfNotPresent(doc, "outline-style");
        this.listStylesNames.addAll(this.mergeUnique(doc, "styles", "text:list-style"));
        if (this.getVersion() == XMLVersion.OOo) {
            this.addStylesIfNotPresent(doc, "footnotes-configuration");
            this.addStylesIfNotPresent(doc, "endnotes-configuration");
        } else {
            this.mergeUnique(doc, "styles", "text:notes-configuration", "text:note-class", NOP_ElementTransformer);
        }
        this.addStylesIfNotPresent(doc, "bibliography-configuration");
        this.addStylesIfNotPresent(doc, "linenumbering-configuration");
    }

    private void mergeAutoStyles(ODXMLDocument doc, boolean ref) throws JDOMException {
        List<Element> addedStyles = this.prefixAndAddAutoStyles(doc);
        for (Element addedStyle : addedStyles) {
            this.prefix(addedStyle, ref);
        }
    }

    private void mergeMasterStyles(ODXMLDocument doc, boolean ref) throws JDOMException {
        this.mergeUnique(doc, "master-styles", "style:master-page", ref ? this.prefixTransf : this.prefixTransfNoRef);
    }

    private void mergeBody(Element where, int index, ODSingleXMLDocument doc) throws JDOMException {
        String formsName = "forms";
        final Namespace formsNS = this.getVersion().getOFFICE();
        String bodyPath = this.getContentTypeVersioned().getBodyPath();
        this.add(new IFactory<Element>(){

            @Override
            public Element createChecked() {
                Element ourForms = ODSingleXMLDocument.this.getBody().getChild("forms", formsNS);
                if (ourForms != null) {
                    return ourForms;
                }
                Element res = new Element("forms", formsNS);
                ODSingleXMLDocument.this.getBody().addContent(0, res);
                return res;
            }
        }, -1, (ODXMLDocument)doc, String.valueOf(bodyPath) + "/" + formsNS.getPrefix() + ":" + "forms", this.prefixTransf);
        this.add(where, index, (ODXMLDocument)doc, bodyPath, new ODXMLDocument.ElementTransformer(){

            @Override
            public Element transform(Element elem) throws JDOMException {
                if (elem.getName().equals("sequence-decls") || elem.getName().equals("forms") && elem.getNamespace().equals(formsNS)) {
                    return null;
                }
                if (elem.getName().equals("user-field-decls")) {
                    ODSingleXMLDocument.this.detachDuplicate(elem);
                }
                if (elem.getName().equals("variable-decls")) {
                    ODSingleXMLDocument.this.detachDuplicate(elem);
                }
                return ODSingleXMLDocument.this.prefixTransf.transform(elem);
            }
        });
    }

    protected final void detachDuplicate(Element elem) throws JDOMException {
        String singularName = elem.getName().substring(0, elem.getName().length() - 1);
        List thisNames = this.getXPath("./text:" + singularName + "s/text:" + singularName + "/@text:name").selectNodes(this.getChild("body"));
        org.apache.commons.collections.CollectionUtils.transform(thisNames, new Transformer(){

            @Override
            public Object transform(Object obj) {
                return ((Attribute)obj).getValue();
            }
        });
        Iterator iter = elem.getChildren().iterator();
        while (iter.hasNext()) {
            Element decl = (Element)iter.next();
            if (!thisNames.contains(decl.getAttributeValue("name", this.getVersion().getTEXT()))) continue;
            iter.remove();
        }
    }

    public final Element getBody() {
        return this.getContentTypeVersioned().getBody(this.getDocument());
    }

    private ContentTypeVersioned getContentTypeVersioned() {
        return ContentType.TEXT.getVersioned(this.getVersion());
    }

    public final String checkStyles() {
        try {
            CollectionMap<String, String> stylesNames = this.getStylesNames();
            HashSet<String> names = new HashSet<String>(stylesNames.values());
            for (Attribute attr : this.getXPath(".//@text:style-name | .//@table:style-name | .//@draw:style-name | .//@style:data-style-name | .//@style:list-style-name").selectNodes(this.getDocument())) {
                if (names.contains(attr.getValue())) continue;
                return "unknown style referenced by " + attr.getName() + " in " + JDOMUtils.output(attr.getParent());
            }
        }
        catch (IllegalStateException e) {
            return ExceptionUtils.getStackTrace(e);
        }
        catch (JDOMException e) {
            return ExceptionUtils.getStackTrace(e);
        }
        return null;
    }

    private final CollectionMap<String, String> getStylesNames() throws IllegalStateException {
        CollectionMap<String, String> res = new CollectionMap<String, String>(HashSet.class);
        ArrayList<Element> nodes = new ArrayList<Element>();
        nodes.add(this.getChild("styles"));
        nodes.add(this.getChild("automatic-styles"));
        try {
            for (Attribute attr : this.getXPath("./style:style/@style:name").selectNodes(nodes)) {
                String styleName = attr.getValue();
                String family = attr.getParent().getAttributeValue("family", attr.getNamespace());
                if (res.getNonNull(family).contains(styleName)) {
                    throw new IllegalStateException("duplicate style in " + family + " :  " + styleName);
                }
                res.put((Object)family, (Object)styleName);
            }
            List<String> dataStyles = Arrays.asList("number-style", "currency-style", "percentage-style", "date-style", "time-style", "boolean-style", "text-style");
            String xpDataStyles = CollectionUtils.join(dataStyles, " | ", new ITransformer<String, String>(){

                @Override
                public String transformChecked(String input) {
                    return "./number:" + input;
                }
            });
            for (Element elem : this.getXPath("./text:list-style | " + xpDataStyles).selectNodes(nodes)) {
                res.put((Object)elem.getQualifiedName(), (Object)elem.getAttributeValue("name", this.getVersion().getSTYLE()));
            }
        }
        catch (JDOMException e) {
            throw new IllegalStateException(e);
        }
        return res;
    }

    void prefix(Element elem, boolean references) throws JDOMException {
        for (Attribute attr : this.getXPath(".//@text:style-name | .//@table:style-name | .//@draw:style-name | .//@style:data-style-name").selectNodes(elem)) {
            if (this.listStylesNames.contains(attr.getValue()) || this.stylesNames.contains(attr.getValue())) continue;
            attr.setValue(this.prefix(attr.getValue()));
        }
        for (Attribute attr : this.getXPath(".//@style:list-style-name").selectNodes(elem)) {
            if (this.listStylesNames.contains(attr.getValue())) continue;
            attr.setValue(this.prefix(attr.getValue()));
        }
        for (Attribute attr : this.getXPath(".//@style:page-master-name | .//@style:page-layout-name | .//@text:name | .//@form:name | .//@form:property-name").selectNodes(elem)) {
            String parentName = attr.getParent().getName();
            if (DONT_PREFIX.contains(parentName)) continue;
            attr.setValue(this.prefix(attr.getValue()));
        }
        if (references) {
            for (Attribute attr : this.getXPath(".//@xlink:href[../@xlink:show='embed']").selectNodes(elem)) {
                String prefixedPath = this.prefixPath(attr.getValue());
                if (prefixedPath == null) continue;
                attr.setValue(prefixedPath);
            }
        }
    }

    private String prefixPath(String href) {
        boolean inPKGFile;
        URI uri;
        if (this.getVersion().equals((Object)XMLVersion.OOo)) {
            boolean sharp = href.startsWith("#");
            if (sharp) {
                return "#" + this.prefix(href.substring(1));
            }
            return null;
        }
        try {
            uri = new URI(href);
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        boolean bl = inPKGFile = uri == null || uri.getScheme() == null && uri.getAuthority() == null && uri.getPath().charAt(0) != '/';
        if (inPKGFile) {
            String dotSlash = "./";
            if (href.startsWith("./")) {
                return "./" + this.prefix(href.substring("./".length()));
            }
            return this.prefix(href);
        }
        return null;
    }

    private String prefix(String value) {
        return "_" + this.numero + value;
    }

    private List<String> mergeUnique(ODXMLDocument doc, String topElem, String elemToMerge) throws JDOMException {
        return this.mergeUnique(doc, topElem, elemToMerge, NOP_ElementTransformer);
    }

    private List<String> mergeUnique(ODXMLDocument doc, String topElem, String elemToMerge, ODXMLDocument.ElementTransformer addTransf) throws JDOMException {
        return this.mergeUnique(doc, topElem, elemToMerge, "style:name", addTransf);
    }

    private List<String> mergeUnique(ODXMLDocument doc, String topElem, String elemToMerge, String attrFQName, ODXMLDocument.ElementTransformer addTransf) throws JDOMException {
        ArrayList<String> added = new ArrayList<String>();
        Element thisParent = this.getChild(topElem, true);
        XPath xp = this.getXPath("./" + elemToMerge + "/@" + attrFQName);
        List thisElemNames = xp.selectNodes(thisParent);
        org.apache.commons.collections.CollectionUtils.transform(thisElemNames, new Transformer(){

            @Override
            public Object transform(Object obj) {
                return ((Attribute)obj).getValue();
            }
        });
        for (Attribute attr : xp.selectNodes(doc.getChild(topElem))) {
            if (thisElemNames.contains(attr.getValue())) continue;
            thisParent.addContent(addTransf.transform((Element)attr.getParent().clone()));
            added.add(attr.getValue());
        }
        return added;
    }

    private void addStylesIfNotPresent(ODXMLDocument doc, String elemName) throws JDOMException {
        this.addIfNotPresent(doc, "./office:styles/text:" + elemName);
    }

    private List<Element> prefixAndAddAutoStyles(ODXMLDocument doc) throws JDOMException {
        ArrayList<Element> result = new ArrayList<Element>(128);
        List otherNames = this.getXPath("./*/@style:name").selectNodes(doc.getChild("automatic-styles"));
        for (Attribute attr : otherNames) {
            Element parent = (Element)attr.getParent().clone();
            parent.setAttribute("name", this.prefix(attr.getValue()), this.getVersion().getSTYLE());
            this.getChild("automatic-styles").addContent(parent);
            result.add(parent);
        }
        return result;
    }

    public final boolean isDead() {
        return this.getPackage() == null;
    }

    final Map<ODPackage.RootElement, Document> split() {
        Element thisSettings;
        HashMap<ODPackage.RootElement, Document> res = new HashMap<ODPackage.RootElement, Document>();
        XMLVersion version = this.getVersion();
        Element root = this.getDocument().getRootElement();
        String officeVersion = this.getFormatVersion().getOfficeVersion();
        Element thisMeta = root.getChild("meta", version.getOFFICE());
        if (thisMeta != null) {
            Document meta = this.createDocument(res, ODPackage.RootElement.META, version, officeVersion);
            meta.getRootElement().addContent(thisMeta.detach());
        }
        if ((thisSettings = root.getChild("settings", version.getOFFICE())) != null) {
            Document settings = this.createDocument(res, ODPackage.RootElement.SETTINGS, version, officeVersion);
            settings.getRootElement().addContent(thisSettings.detach());
        }
        Document styles = this.createDocument(res, ODPackage.RootElement.STYLES, version, officeVersion);
        styles.getRootElement().addContent((Element)root.getChild(this.getFontDecls()[0], version.getOFFICE()).clone());
        styles.getRootElement().addContent(root.getChild("styles", version.getOFFICE()).detach());
        Element contentAutoStyles = root.getChild("automatic-styles", version.getOFFICE());
        Element stylesAutoStyles = new Element(contentAutoStyles.getName(), contentAutoStyles.getNamespace());
        Element masterStyles = root.getChild("master-styles", version.getOFFICE());
        HashSet<Element> referenced = new HashSet<Element>();
        SimpleXMLPath<Attribute> descAttrs = SimpleXMLPath.create(Step.createElementStep(Step.Axis.descendantOrSelf, null), Step.createAttributeStep(null, null));
        for (Attribute attr : descAttrs.selectNodes(masterStyles)) {
            Element referencedStyleElement = Style.getReferencedStyleElement(this.pkg, attr);
            if (referencedStyleElement == null) continue;
            referenced.add(referencedStyleElement);
        }
        for (Element r : referenced) {
            assert (r.getParentElement() == contentAutoStyles);
            stylesAutoStyles.addContent(r.detach());
        }
        styles.getRootElement().addContent(stylesAutoStyles);
        styles.getRootElement().addContent(masterStyles.detach());
        this.pkg = null;
        Document content = this.createDocument(res, ODPackage.RootElement.CONTENT, version, officeVersion);
        this.getContentTypeVersioned().setType(content);
        content.getRootElement().addContent(root.removeContent());
        return res;
    }

    private Document createDocument(Map<ODPackage.RootElement, Document> res, ODPackage.RootElement rootElement, XMLVersion version, String officeVersion) {
        Document doc = rootElement.createDocument(version, officeVersion);
        ODSingleXMLDocument.copyNS(this.getDocument(), doc);
        res.put(rootElement, doc);
        return doc;
    }

    public File saveAs(File f) throws IOException {
        return this.pkg.saveAs(f);
    }

    private Element getPageBreak() {
        if (this.pageBreak == null) {
            String styleName = "PageBreak";
            try {
                XPath xp = this.getXPath("./style:style[@style:name='PageBreak']");
                Element styles = this.getChild("styles", true);
                if (xp.selectSingleNode(styles) == null) {
                    Element pageBreakStyle = new Element("style", this.getVersion().getSTYLE());
                    pageBreakStyle.setAttribute("name", "PageBreak", this.getVersion().getSTYLE());
                    pageBreakStyle.setAttribute("family", "paragraph", this.getVersion().getSTYLE());
                    pageBreakStyle.setContent(this.getPProps().setAttribute("break-after", "page", this.getVersion().getNS("fo")));
                    styles.addContent(pageBreakStyle);
                }
            }
            catch (JDOMException e) {
                throw new IllegalStateException("pb while searching for PageBreak", e);
            }
            this.pageBreak = new Element("p", this.getVersion().getTEXT()).setAttribute("style-name", "PageBreak", this.getVersion().getTEXT());
        }
        return (Element)this.pageBreak.clone();
    }

    private final Element getPProps() {
        return this.getXML().createFormattingProperties("paragraph");
    }
}

