/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.openoffice.ContentTypeVersioned;
import org.openconcerto.openoffice.Manifest;
import org.openconcerto.openoffice.ODMeta;
import org.openconcerto.openoffice.ODPackageEntry;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.openoffice.ODXMLDocument;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.OOXML;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.utils.CopyUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.StringInputStream;
import org.openconcerto.utils.Zip;
import org.openconcerto.utils.ZippedFilesProcessor;

public class ODPackage {
    private static final XMLOutputter OUTPUTTER = new XMLOutputter(Format.getRawFormat());
    static final Charset MIMETYPE_ENC = Charset.forName("UTF-8");
    private static final Set<String> subdocNames = new HashSet<String>();
    private final Map<String, ODPackageEntry> files = new HashMap<String, ODPackageEntry>();
    private ContentTypeVersioned type = null;
    private File file = null;

    static {
        for (RootElement r : RootElement.getPackageElements()) {
            if (r.getZipEntry() == null) continue;
            subdocNames.add(r.getZipEntry());
        }
    }

    public static final boolean isStandardFile(String name) {
        return name.equals("mimetype") || subdocNames.contains(name) || name.startsWith("Thumbnails") || name.startsWith("META-INF") || name.startsWith("Configurations");
    }

    public ODPackage() {
    }

    public ODPackage(InputStream ins) throws IOException {
        this();
        final ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        new ZippedFilesProcessor(){

            @Override
            protected void processEntry(ZipEntry entry, InputStream in) throws IOException {
                Object res;
                String name = entry.getName();
                if (subdocNames.contains(name)) {
                    try {
                        res = new ODXMLDocument(OOUtils.getBuilder().build(in));
                    }
                    catch (JDOMException e) {
                        throw new IllegalStateException("parse error", e);
                    }
                } else {
                    out.reset();
                    StreamUtils.copy(in, out);
                    res = out.toByteArray();
                }
                ODPackage.this.putFile(name, res, null, entry.getMethod() == 8);
            }
        }.process(ins);
        ODPackageEntry me = this.files.remove("META-INF/manifest.xml");
        if (me != null) {
            byte[] m = (byte[])me.getData();
            try {
                Map<String, String> manifestEntries = Manifest.parse(new ByteArrayInputStream(m));
                for (Map.Entry<String, String> e : manifestEntries.entrySet()) {
                    String path = e.getKey();
                    ODPackageEntry entry = this.files.get(path);
                    if (entry == null) {
                        this.files.put(path, new ODPackageEntry(path, e.getValue(), null));
                        continue;
                    }
                    entry.setType(e.getValue());
                }
            }
            catch (JDOMException e) {
                throw new IllegalArgumentException("bad manifest " + new String(m), e);
            }
        }
    }

    public ODPackage(File f) throws IOException {
        this(new BufferedInputStream(new FileInputStream(f), 524288));
        this.file = f;
    }

    public ODPackage(ODPackage o) {
        this();
        for (String name : o.getEntries()) {
            ODPackageEntry entry = o.getEntry(name);
            Object data = entry.getData();
            Object myData = data instanceof byte[] ? data : (data instanceof ODSingleXMLDocument ? new ODSingleXMLDocument((ODSingleXMLDocument)data, this) : CopyUtils.copy(data));
            this.putFile(name, myData, entry.getType(), entry.isCompressed());
        }
        this.type = o.type;
        this.file = o.file;
    }

    public final File getFile() {
        return this.file;
    }

    public final void setFile(File f) {
        this.file = this.addExt(f);
    }

    private final File addExt(File f) {
        String ext = String.valueOf('.') + this.getContentType().getExtension();
        if (!f.getName().endsWith(ext)) {
            f = new File(f.getParentFile(), String.valueOf(f.getName()) + ext);
        }
        return f;
    }

    public final XMLVersion getVersion() {
        XMLFormatVersion res = this.getFormatVersion();
        return res == null ? null : res.getXMLVersion();
    }

    public final XMLFormatVersion getFormatVersion() {
        ODXMLDocument content = this.getContent();
        if (content == null) {
            return null;
        }
        return content.getFormatVersion();
    }

    public final ContentTypeVersioned getContentType() {
        if (this.type == null) {
            if (this.files.containsKey("mimetype")) {
                this.type = ContentTypeVersioned.fromMime(new String(this.getBinaryFile("mimetype"), MIMETYPE_ENC));
            } else if (this.getVersion().equals((Object)XMLVersion.OOo)) {
                Element contentRoot = this.getContent().getDocument().getRootElement();
                String docClass = contentRoot.getAttributeValue("class", contentRoot.getNamespace("office"));
                this.type = ContentTypeVersioned.fromClass(docClass);
            } else if (this.getVersion().equals((Object)XMLVersion.OD)) {
                Element bodyChild = (Element)this.getContent().getChild("body").getChildren().get(0);
                this.type = ContentTypeVersioned.fromBody(bodyChild.getName());
            }
        }
        return this.type;
    }

    public final String getMimeType() {
        return this.getContentType().getMimeType();
    }

    public final Map<String, String> validateSubDocuments() {
        OOXML ooxml = this.getFormatVersion().getXML();
        if (!ooxml.canValidate()) {
            return null;
        }
        HashMap<String, String> res = new HashMap<String, String>();
        for (String s : subdocNames) {
            String valid;
            if (!this.getEntries().contains(s) || (valid = ooxml.getValidator(this.getDocument(s)).isValid()) == null) continue;
            res.put(s, valid);
        }
        return res;
    }

    public final Set<String> getEntries() {
        return this.files.keySet();
    }

    public final ODPackageEntry getEntry(String entry) {
        return this.files.get(entry);
    }

    protected final Object getData(String entry) {
        ODPackageEntry e = this.getEntry(entry);
        return e == null ? null : e.getData();
    }

    public final byte[] getBinaryFile(String entry) {
        return (byte[])this.getData(entry);
    }

    public final ODXMLDocument getXMLFile(String xmlEntry) {
        return (ODXMLDocument)this.getData(xmlEntry);
    }

    public final ODXMLDocument getXMLFile(Document doc) {
        for (String s : subdocNames) {
            ODXMLDocument xmlFile = this.getXMLFile(s);
            if (xmlFile == null || xmlFile.getDocument() != doc) continue;
            return xmlFile;
        }
        return null;
    }

    public final ODXMLDocument getContent() {
        return this.getXMLFile(RootElement.CONTENT.getZipEntry());
    }

    public final ODMeta getMeta() {
        ODMeta meta = this.getEntries().contains(RootElement.META.getZipEntry()) ? ODMeta.create(this.getXMLFile(RootElement.META.getZipEntry())) : ODMeta.create(this.getContent());
        return meta;
    }

    public Document getDocument(String xmlEntry) {
        ODXMLDocument xml = this.getXMLFile(xmlEntry);
        return xml == null ? null : xml.getDocument();
    }

    public final Element getStyle(StyleDesc<?> desc, String name) {
        return this.getStyle(this.getContent().getDocument(), desc, name);
    }

    public final Element getStyle(Document referent, StyleDesc<?> desc, String name) {
        String[] stylesContainer;
        if (name == null) {
            return null;
        }
        String refSubDoc = null;
        String[] stringArray = stylesContainer = new String[]{RootElement.CONTENT.getZipEntry(), RootElement.STYLES.getZipEntry()};
        int n = stylesContainer.length;
        int n2 = 0;
        while (n2 < n) {
            String subDoc = stringArray[n2];
            if (this.getDocument(subDoc) == referent) {
                refSubDoc = subDoc;
            }
            ++n2;
        }
        if (refSubDoc == null) {
            throw new IllegalArgumentException("neither in content nor styles : " + referent);
        }
        Element res = this.getXMLFile(refSubDoc).getStyle(desc, name);
        if (res == null && refSubDoc.equals(stylesContainer[0]) && this.getXMLFile(stylesContainer[1]) != null) {
            res = this.getXMLFile(stylesContainer[1]).getStyle(desc, name);
        }
        return res;
    }

    public void putFile(String entry, Object data) {
        this.putFile(entry, data, null);
    }

    public void putFile(String entry, Object data, String mediaType) {
        this.putFile(entry, data, mediaType, true);
    }

    public void putFile(String entry, Object data, String mediaType, boolean compress) {
        Object myData;
        if (entry == null) {
            throw new NullPointerException("null name");
        }
        if (subdocNames.contains(entry)) {
            ODXMLDocument oodoc = data instanceof Document ? new ODXMLDocument((Document)data) : (ODXMLDocument)data;
            if (this.getVersion() != null && !oodoc.getVersion().equals((Object)this.getVersion())) {
                throw new IllegalArgumentException("version mismatch " + (Object)((Object)this.getVersion()) + " != " + oodoc);
            }
            myData = oodoc;
        } else {
            if (data != null && !(data instanceof byte[])) {
                throw new IllegalArgumentException("should be byte[] for " + entry + ": " + data);
            }
            myData = data;
        }
        String inferredType = mediaType != null ? mediaType : FileUtils.findMimeType(entry);
        this.files.put(entry, new ODPackageEntry(entry, inferredType, myData, compress));
    }

    public void rmFile(String entry) {
        this.files.remove(entry);
    }

    public ODSingleXMLDocument toSingle() {
        if (!this.isSingle()) {
            Document content = this.removeAndGetDoc(RootElement.CONTENT.getZipEntry());
            Document styles = this.removeAndGetDoc(RootElement.STYLES.getZipEntry());
            Document settings = this.removeAndGetDoc(RootElement.SETTINGS.getZipEntry());
            Document meta = this.removeAndGetDoc(RootElement.META.getZipEntry());
            return ODSingleXMLDocument.createFromDocument(content, styles, settings, meta, this);
        }
        return (ODSingleXMLDocument)this.getContent();
    }

    public final boolean isSingle() {
        return this.getContent() instanceof ODSingleXMLDocument;
    }

    private Document removeAndGetDoc(String name) {
        if (!this.files.containsKey(name)) {
            return null;
        }
        ODXMLDocument xmlDoc = (ODXMLDocument)this.files.remove(name).getData();
        return xmlDoc == null ? null : xmlDoc.getDocument();
    }

    public final boolean split() {
        boolean res;
        if (this.isSingle()) {
            Map<RootElement, Document> split = ((ODSingleXMLDocument)this.getContent()).split();
            assert ((split.containsKey((Object)RootElement.CONTENT) || split.containsKey((Object)RootElement.STYLES)) && RootElement.getPackageElements().containsAll(split.keySet())) : "wrong elements " + split;
            XMLFormatVersion version = this.getFormatVersion();
            for (Map.Entry<RootElement, Document> e : split.entrySet()) {
                this.putFile(e.getKey().getZipEntry(), new ODXMLDocument(e.getValue(), version));
            }
            res = true;
        } else {
            res = false;
        }
        assert (!this.isSingle());
        return res;
    }

    public final void save(OutputStream out) throws IOException {
        if (this.isSingle()) {
            assert (this.getClass() == ODPackage.class);
            ODPackage copy2 = new ODPackage(this);
            copy2.split();
            copy2.save(out);
            return;
        }
        Zip z = new Zip(out);
        z.zipNonCompressed("mimetype", this.getMimeType().getBytes(MIMETYPE_ENC));
        Manifest manifest = new Manifest(this.getVersion(), this.getMimeType());
        for (String name : this.files.keySet()) {
            String mediaType;
            if (name.equals("mimetype") || name.equals("META-INF/manifest.xml")) continue;
            ODPackageEntry entry = this.files.get(name);
            Object val = entry.getData();
            if (val != null) {
                if (val instanceof ODXMLDocument) {
                    OutputStream o = z.createEntry(name);
                    OUTPUTTER.output(((ODXMLDocument)val).getDocument(), o);
                    o.close();
                } else {
                    z.zip(name, (byte[])val, entry.isCompressed());
                }
            }
            manifest.addEntry(name, (mediaType = entry.getType()) == null ? "" : mediaType);
        }
        z.zip("META-INF/manifest.xml", new StringInputStream(manifest.asString()));
        z.close();
    }

    public File save() throws IOException {
        return this.saveAs(this.getFile());
    }

    public File saveAs(File fNoExt) throws IOException {
        File f = this.addExt(fNoExt);
        if (f.getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(f);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(out, 524288);
        try {
            this.save(bufferedOutputStream);
        }
        finally {
            bufferedOutputStream.close();
        }
        return f;
    }

    public static enum RootElement {
        SINGLE_CONTENT("office", "document", null),
        CONTENT("office", "document-content", "content.xml"),
        STYLES("office", "document-styles", "styles.xml"),
        META("office", "document-meta", "meta.xml"),
        SETTINGS("office", "document-settings", "settings.xml");

        private final String nsPrefix;
        private final String name;
        private final String zipEntry;

        public static final EnumSet<RootElement> getPackageElements() {
            return EnumSet.of(CONTENT, STYLES, META, SETTINGS);
        }

        public static final RootElement fromElementName(String name) {
            RootElement[] rootElementArray = RootElement.values();
            int n = rootElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                RootElement e = rootElementArray[n2];
                if (e.getElementName().equals(name)) {
                    return e;
                }
                ++n2;
            }
            return null;
        }

        static final Document createSingle(Document from) {
            XMLFormatVersion version = XMLFormatVersion.get(from);
            return SINGLE_CONTENT.createDocument(version.getXMLVersion(), version.getOfficeVersion());
        }

        private RootElement(String prefix, String rootName, String zipEntry) {
            this.nsPrefix = prefix;
            this.name = rootName;
            this.zipEntry = zipEntry;
        }

        public final String getElementNSPrefix() {
            return this.nsPrefix;
        }

        public final String getElementName() {
            return this.name;
        }

        public final Document createDocument(XMLVersion version, String officeVersion) {
            Element root = new Element(this.getElementName(), version.getNS(this.getElementNSPrefix()));
            if (officeVersion != null) {
                root.setAttribute("version", officeVersion, version.getOFFICE());
            }
            Namespace[] namespaceArray = version.getALL();
            int n = namespaceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Namespace ns = namespaceArray[n2];
                root.addNamespaceDeclaration(ns);
                ++n2;
            }
            Document res = new Document(root);
            if (version == XMLVersion.OOo) {
                res.setDocType(new DocType(String.valueOf(this.getElementNSPrefix()) + ":" + this.getElementName(), "-//OpenOffice.org//DTD OfficeDocument 1.0//EN", "office.dtd"));
            }
            return res;
        }

        public final String getZipEntry() {
            return this.zipEntry;
        }
    }
}

