/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.openconcerto.openoffice.ChildCreator;
import org.openconcerto.openoffice.ODNode;
import org.openconcerto.openoffice.ODUserDefinedMeta;
import org.openconcerto.openoffice.ODXMLDocument;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.XMLVersion;

public class ODMeta
extends ODNode {
    private static final Map<XMLVersion, List<Element>> ELEMS_ORDER = new HashMap<XMLVersion, List<Element>>(2);
    private final ODXMLDocument parent;
    private final ChildCreator childCreator;

    static {
        ELEMS_ORDER.put(XMLVersion.getOOo(), ODMeta.createChildren(XMLVersion.getOOo()));
        ELEMS_ORDER.put(XMLVersion.getOD(), ODMeta.createChildren(XMLVersion.getOD()));
    }

    static ODMeta create(ODXMLDocument parent) {
        Element meta = parent.getChild("meta");
        return meta == null ? null : new ODMeta(meta, parent);
    }

    private static final List<Element> createChildren(XMLVersion ins) {
        Namespace meta = ins.getMETA();
        Namespace dc = ins.getNS("dc");
        ArrayList<Element> res = new ArrayList<Element>(8);
        res.add(new Element("generator", meta));
        res.add(new Element("title", dc));
        res.add(new Element("description", dc));
        res.add(new Element("subject", dc));
        res.add(new Element("keyword", meta));
        res.add(new Element("initial-creator", meta));
        res.add(new Element("creator", dc));
        res.add(new Element("printed-by", meta));
        res.add(new Element("creation-date", meta));
        res.add(new Element("date", dc));
        res.add(new Element("print-date", meta));
        res.add(new Element("template", meta));
        res.add(new Element("auto-reload", meta));
        res.add(new Element("hyperlink-behaviour", meta));
        res.add(new Element("language", dc));
        res.add(new Element("editing-cycles", meta));
        res.add(new Element("editing-duration", meta));
        res.add(new Element("document-statistic", meta));
        res.add(new Element("user-defined", meta));
        return res;
    }

    private ODMeta(Element elem, ODXMLDocument parent) {
        super(elem);
        this.parent = parent;
        this.childCreator = new ChildCreator(this.getElement(), ELEMS_ORDER.get((Object)this.getNS()));
    }

    protected final ODXMLDocument getParent() {
        return this.parent;
    }

    private final XMLVersion getNS() {
        return this.getParent().getVersion();
    }

    public final String getGenerator() {
        return this.getMetaChild("generator").getTextTrim();
    }

    public final void setGenerator(String s) {
        this.getMetaChild("generator").setText(s);
    }

    public final String getTitle() {
        return this.getDCChild("title").getTextTrim();
    }

    public final void setTitle(String s) {
        this.getDCChild("title").setText(s);
    }

    public final String getDescription() {
        return this.getDCChild("description").getTextTrim();
    }

    public final void setDescription(String s) {
        this.getDCChild("description").setText(s);
    }

    public final String getSubject() {
        return this.getDCChild("subject").getTextTrim();
    }

    public final void setSubject(String s) {
        this.getDCChild("subject").setText(s);
    }

    public final List<String> getKeywords() {
        List<Element> keywordsElem = this.getKeywordElems();
        ArrayList<String> res = new ArrayList<String>(keywordsElem.size());
        for (Element elem : keywordsElem) {
            res.add(elem.getTextTrim());
        }
        return res;
    }

    private List<Element> getKeywordElems() {
        return this.getElement().getChildren("keyword", this.getNS().getMETA());
    }

    public final void setKeywords(List<String> s) {
        this.getKeywordElems().clear();
        for (String keyword : s) {
            this.childCreator.addChild(this.getNS().getMETA(), "keyword").setText(keyword);
        }
    }

    public final String getInitialCreator() {
        return this.getMetaChild("initial-creator").getTextTrim();
    }

    public final void setInitialCreator(String s) {
        this.getMetaChild("initial-creator").setText(s);
    }

    public final String getCreator() {
        return this.getDCChild("creator").getTextTrim();
    }

    public final void setCreator(String s) {
        this.getDCChild("creator").setText(s);
    }

    public final Calendar getCreationDate() {
        return this.getDateChild("creation-date", this.getNS().getMETA());
    }

    public final void setCreationDate(Calendar cal) {
        this.setDateChild(cal, "creation-date", this.getNS().getMETA());
    }

    public final Calendar getModifDate() {
        return this.getDateChild("date", this.getNS().getNS("dc"));
    }

    public final void setModifDate(Calendar cal) {
        this.setDateChild(cal, "date", this.getNS().getNS("dc"));
    }

    public final String getLanguage() {
        return this.getDCChild("language").getTextTrim();
    }

    public final void setLanguage(String s) {
        this.getDCChild("language").setText(s);
    }

    public final int getEditingCycles() {
        return Integer.parseInt(this.getMetaChild("editing-cycles").getTextTrim());
    }

    public final void setInitialCreator(int s) {
        this.getMetaChild("editing-cycles").setText(String.valueOf(s));
    }

    public final ODUserDefinedMeta getUserMeta(String name) {
        return this.getUserMeta(name, false);
    }

    public final ODUserDefinedMeta getUserMeta(String name, boolean create) {
        return this.getUserMeta(name, create ? Integer.valueOf(-1) : null);
    }

    public final ODUserDefinedMeta getUserMeta(String name, Integer index) {
        Element userElem = ODUserDefinedMeta.getElement(this.getElement(), name, this.getNS());
        if (userElem != null) {
            return new ODUserDefinedMeta(userElem, this.getParent());
        }
        if (index != null) {
            ODUserDefinedMeta res = ODUserDefinedMeta.create(name, this.getParent());
            if (index == -1) {
                this.getElement().addContent(res.getElement());
            } else {
                List existingChildren = this.getElement().getChildren(res.getElement().getName(), res.getElement().getNamespace());
                existingChildren.add(index, res.getElement());
            }
            return res;
        }
        return null;
    }

    public final void removeUserMeta(String name) {
        ODUserDefinedMeta userMeta = this.getUserMeta(name, false);
        if (userMeta != null) {
            userMeta.getElement().detach();
        }
    }

    public final List<String> getUserMetaNames() throws JDOMException {
        return ODUserDefinedMeta.getNames(this.getElement(), this.getNS());
    }

    public final Element getMetaChild(String name) {
        return this.getChild(name, this.getNS().getMETA());
    }

    public final Element getDCChild(String name) {
        return this.getChild(name, this.getNS().getNS("dc"));
    }

    private final Element getChild(String name, Namespace ns) {
        return this.childCreator.getChild(ns, name, true);
    }

    private final Calendar getDateChild(String name, Namespace ns) {
        String date = this.getChild(name, ns).getTextTrim();
        if (date.length() == 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime((Date)OOUtils.DATE_FORMAT.parseObject(date));
        }
        catch (ParseException e) {
            throw new IllegalStateException("wrong date: " + date, e);
        }
        return cal;
    }

    private final void setDateChild(Calendar cal, String name, Namespace ns) {
        this.getChild(name, ns).setText(OOUtils.DATE_FORMAT.format(cal.getTime()));
    }
}

