/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.math.BigDecimal;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.GraphicStyle;
import org.openconcerto.openoffice.ImmutableDocStyledNode;
import org.openconcerto.openoffice.LengthUnit;
import org.openconcerto.openoffice.ODDocument;

public class ODFrame<D extends ODDocument>
extends ImmutableDocStyledNode<GraphicStyle, D> {
    private final BigDecimal width = ODFrame.parseLengthDecimal(this.getSVGAttr("width"), this.getUnit());
    private final BigDecimal height = ODFrame.parseLengthDecimal(this.getSVGAttr("height"), this.getUnit());

    public static final float parseLength(String l, LengthUnit to) {
        return ODFrame.parseLengthDecimal(l, to).floatValue();
    }

    public static final BigDecimal parseLengthDecimal(String l, LengthUnit to) {
        if (l == null) {
            return null;
        }
        return LengthUnit.parseLength(l, to).stripTrailingZeros();
    }

    public ODFrame(D parent, Element frame) {
        super(parent, frame, GraphicStyle.class);
    }

    public final BigDecimal getWidth() {
        return this.getWidth(this.getUnit());
    }

    public final BigDecimal getWidth(LengthUnit in) {
        return this.getUnit().convertTo(this.width, in);
    }

    public final BigDecimal getHeight() {
        return this.getHeight(this.getUnit());
    }

    public final BigDecimal getHeight(LengthUnit in) {
        return this.getUnit().convertTo(this.height, in);
    }

    private Namespace getSVG() {
        return this.getElement().getNamespace("svg");
    }

    public String getSVGAttr(String name) {
        return this.getElement().getAttributeValue(name, this.getSVG());
    }

    public void setSVGAttr(String name, String val) {
        this.getElement().setAttribute(name, val, this.getSVG());
    }

    public void setSVGAttr(String name, Number val) {
        this.setSVGAttr(name, val + this.getUnit().getSymbol());
    }

    public final double getRatio() {
        return this.getWidth().doubleValue() / this.getHeight().doubleValue();
    }

    public final BigDecimal getX() {
        return ODFrame.parseLengthDecimal(this.getSVGAttr("x"), this.getUnit());
    }

    public final BigDecimal getY() {
        return ODFrame.parseLengthDecimal(this.getSVGAttr("y"), this.getUnit());
    }

    public final LengthUnit getUnit() {
        return LengthUnit.MM;
    }
}

