/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Tuple2;

public enum LengthUnit {
    MM("mm", BigDecimal.ONE),
    CM("cm", BigDecimal.TEN),
    INCH("in", new BigDecimal("25.4")),
    POINT("pt", LengthUnit.INCH.multiplier.divide(new BigDecimal(72), DecimalUtils.HIGH_PRECISION)),
    PICA("pc", LengthUnit.INCH.multiplier.divide(new BigDecimal(6), DecimalUtils.HIGH_PRECISION));

    private final String symbol;
    private final BigDecimal multiplier;
    private static final Pattern lenghPattern;

    static {
        lenghPattern = Pattern.compile("(-?\\d+(\\.\\d+)?)(\\p{Alpha}+)?");
    }

    private LengthUnit(String abbr, BigDecimal multiplier) {
        this.symbol = abbr;
        this.multiplier = multiplier;
    }

    public final String getSymbol() {
        return this.symbol;
    }

    public final BigDecimal convertTo(BigDecimal d, LengthUnit other) {
        if (this == other) {
            return d;
        }
        return d.multiply(this.multiplier).divide(other.multiplier, DecimalUtils.HIGH_PRECISION);
    }

    public static final LengthUnit fromSymbol(String s) {
        LengthUnit[] lengthUnitArray = LengthUnit.values();
        int n = lengthUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            LengthUnit lu = lengthUnitArray[n2];
            if (lu.symbol.equals(s)) {
                return lu;
            }
            ++n2;
        }
        return null;
    }

    private static final String[] parseLength2String(String l) {
        Matcher m = lenghPattern.matcher(l);
        if (!m.matches()) {
            throw new IllegalStateException("unable to parse " + l);
        }
        return new String[]{m.group(1), m.group(3)};
    }

    public static final Tuple2<BigDecimal, LengthUnit> parseLength(String l) {
        if (l == null) {
            return null;
        }
        String[] valAndUnit = LengthUnit.parseLength2String(l);
        LengthUnit unit = LengthUnit.fromSymbol(valAndUnit[1]);
        if (unit == null) {
            throw new IllegalStateException("unknown unit " + (Object)((Object)unit));
        }
        return Tuple2.create(new BigDecimal(valAndUnit[0]), unit);
    }

    public static final BigDecimal parseLength(String l, LengthUnit to) {
        if (l == null) {
            return null;
        }
        Tuple2<BigDecimal, LengthUnit> valAndUnit = LengthUnit.parseLength(l);
        return valAndUnit.get1().convertTo(valAndUnit.get0(), to);
    }

    public static final BigDecimal parsePositiveLength(String l, LengthUnit to, boolean strict) {
        BigDecimal res = LengthUnit.parseLength(l, to);
        if (res.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException(res + " < 0");
        }
        if (strict && res.compareTo(BigDecimal.ZERO) == 0) {
            throw new IllegalArgumentException(res + " == 0");
        }
        return res;
    }
}

