/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.openconcerto.openoffice.Grep;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class GrepFrame
extends JFrame {
    private JTextField patternTF;
    private JButton fileBtn;
    private JPanel emptyPanel;
    private JButton grepBtn;
    private JLabel fileTF;
    private JLabel fileL;
    private JLabel patternL;
    private final Preferences pref;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GrepFrame inst = new GrepFrame();
                inst.setLocationRelativeTo(null);
                inst.setVisible(true);
            }
        });
    }

    public GrepFrame() {
        this((String)null, (String)null);
    }

    public GrepFrame(String pattern, String path) {
        this.initGUI();
        this.pref = Preferences.userRoot().node("/ilm/openoffice/grep");
        this.patternTF.setText(pattern == null ? this.pref.get("pattern", "pattern") : pattern);
        this.fileTF.setText(path == null ? this.pref.get("path", ".") : path);
    }

    private void initGUI() {
        this.setDefaultCloseOperation(2);
        GridLayout thisLayout = new GridLayout(3, 3);
        thisLayout.setColumns(3);
        thisLayout.setHgap(5);
        thisLayout.setVgap(5);
        thisLayout.setRows(3);
        this.getContentPane().setLayout(thisLayout);
        this.setPreferredSize(new Dimension(800, 254));
        this.patternTF = new JTextField();
        this.patternTF.setText("regexp");
        this.patternTF.setBounds(162, 12, 218, 21);
        this.patternTF.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                GrepFrame.this.pref.put("pattern", GrepFrame.this.patternTF.getText());
                GrepFrame.this.prefChanged();
            }
        });
        this.patternL = new JLabel();
        this.getContentPane().add(this.patternL);
        this.patternL.setText("Pattern");
        this.patternL.setBounds(30, 15, 84, 14);
        this.getContentPane().add(this.patternTF);
        this.emptyPanel = new JPanel();
        this.getContentPane().add(this.emptyPanel);
        this.fileL = new JLabel();
        this.fileL.setText("File");
        this.fileL.setBounds(30, 41, 23, 14);
        this.getContentPane().add(this.fileL);
        this.fileTF = new JLabel();
        this.fileTF.setBounds(162, 41, 217, 18);
        this.getContentPane().add(this.fileTF);
        this.fileBtn = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(2);
                File file = new File(GrepFrame.this.fileTF.getText());
                if (file.exists()) {
                    fc.setSelectedFile(file);
                }
                if (fc.showOpenDialog(GrepFrame.this) == 0) {
                    GrepFrame.this.fileTF.setText(fc.getSelectedFile().getPath());
                    GrepFrame.this.pref.put("path", fc.getSelectedFile().getPath());
                    GrepFrame.this.prefChanged();
                }
            }
        });
        this.fileBtn.setText("Choisir");
        this.fileBtn.setBounds(392, 38, 120, 21);
        this.getContentPane().add(this.fileBtn);
        this.grepBtn = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Grep(GrepFrame.this.patternTF.getText()).grep(new File(GrepFrame.this.fileTF.getText()));
            }
        });
        this.grepBtn.setText("Grep");
        this.grepBtn.setBounds(30, 79, 120, 21);
        this.getContentPane().add(this.grepBtn);
        this.pack();
        this.setSize(1000, 254);
    }

    protected void prefChanged() {
        try {
            this.pref.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

