/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.awt.GraphicsEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.swing.SwingUtilities;
import org.openconcerto.openoffice.GrepFrame;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.ZippedFilesProcessor;
import org.openconcerto.utils.cc.IClosure;

public class Grep {
    private static final int CONTEXT_CHARS = 30;
    private final Pattern pattern;

    public static void main(String[] args) throws IOException {
        if (!GraphicsEnvironment.isHeadless()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GrepFrame inst = new GrepFrame();
                    inst.setDefaultCloseOperation(3);
                    inst.setLocationRelativeTo(null);
                    inst.setVisible(true);
                }
            });
        } else if (args.length != 2) {
            Grep.usage();
        } else {
            String file = args[args.length - 1];
            String pattern = args[args.length - 2];
            new Grep(pattern).grep(new File(file));
        }
    }

    private static void usage() {
        System.out.println("Usage: " + Grep.class.getName() + " pattern (ODFile|dir)");
    }

    public Grep(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public final void grep(File dir) {
        FileUtils.walk(dir, new IClosure<File>(){

            @Override
            public void executeChecked(File f) {
                try {
                    Grep.this.grepFile(f);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private final void grepFile(final File odfile) throws IOException {
        if (!this.isODFile(odfile)) {
            return;
        }
        final ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileInputStream ins = new FileInputStream(odfile);
        try {
            new ZippedFilesProcessor(){

                @Override
                protected void processEntry(ZipEntry entry, InputStream in) throws IOException {
                    if (entry.getName().endsWith(".xml")) {
                        out.reset();
                        StreamUtils.copy(in, out);
                        String s = out.toString("UTF8");
                        Matcher matcher = Grep.this.pattern.matcher(s);
                        while (matcher.find()) {
                            int start = Math.max(0, matcher.start() - 30);
                            int end2 = Math.min(s.length(), matcher.end() + 30);
                            System.out.println(odfile + "!" + entry.getName() + "\t" + s.substring(start, end2));
                        }
                    }
                }
            }.process(ins);
        }
        finally {
            ((InputStream)ins).close();
        }
    }

    private boolean isODFile(File odfile) {
        return odfile.isFile() && (odfile.getName().endsWith(".sxw") || odfile.getName().endsWith(".odt"));
    }
}

