/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Element;
import org.jdom.Namespace;

public class ChildCreator {
    private final Element content;
    private final List<Element> elemsOrder;

    protected ChildCreator(Element content, List<Element> children) {
        if (content == null) {
            throw new NullPointerException("null content");
        }
        this.content = content;
        this.elemsOrder = new ArrayList<Element>(children);
    }

    public ChildCreator(Element content, Element ... children) {
        this(content, Arrays.asList(children));
    }

    public final Element getElement() {
        return this.content;
    }

    public final List<Element> getChildren() {
        return this.elemsOrder;
    }

    public final Element getChild(Namespace childNS, String childName) {
        return this.getChild(childNS, childName, false);
    }

    private final int indexOf(Namespace childNS, String childName) {
        int i = 0;
        while (i < this.elemsOrder.size()) {
            Element elem = this.elemsOrder.get(i);
            if (elem.getNamespace().equals(childNS) && elem.getName().equals(childName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private final int indexOf(Element elem) {
        return this.indexOf(elem.getNamespace(), elem.getName());
    }

    private final int findInsertIndex(Namespace childNS, String childName) {
        int idealIndex = this.indexOf(childNS, childName);
        if (idealIndex == -1) {
            throw new IllegalArgumentException(String.valueOf(childName) + " is unknown.");
        }
        Element existingChild = this.getChild(childNS, childName);
        if (existingChild != null) {
            return this.getElement().getChildren().indexOf(existingChild) + 1;
        }
        List children = this.getElement().getChildren();
        ListIterator iter = children.listIterator();
        while (iter.hasNext()) {
            Element elem = (Element)iter.next();
            if (this.indexOf(elem) <= idealIndex) continue;
            return iter.previousIndex();
        }
        return children.size();
    }

    private final void insertChild(Element child) {
        this.getElement().getChildren().add(this.findInsertIndex(child.getNamespace(), child.getName()), child);
    }

    public final Element getChild(Namespace childNS, String childName, boolean create) {
        Element child = this.getElement().getChild(childName, childNS);
        if (create && child == null) {
            child = new Element(childName, childNS);
            this.insertChild(child);
        }
        return child;
    }

    public final Element addChild(Namespace childNS, String childName) {
        Element child = new Element(childName, childNS);
        this.insertChild(child);
        return child;
    }

    public final void setChild(Element elem) {
        this.getElement().removeChildren(elem.getName(), elem.getNamespace());
        this.insertChild(elem);
    }
}

