/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.odtemplate.statements;

import org.jdom.Element;
import org.openconcerto.odtemplate.TemplateException;
import org.openconcerto.odtemplate.engine.DataModel;
import org.openconcerto.odtemplate.engine.Processor;
import org.openconcerto.odtemplate.statements.BaseStatement;

public class SetStmt
extends BaseStatement {
    public SetStmt() {
        super("set");
    }

    @Override
    public void prepare(Element script, Element command) throws TemplateException {
        String var = command.getAttributeValue("var");
        if (var == null) {
            throw new TemplateException("missing required attribute \"var\" for \"set\" tag");
        }
        String value = command.getAttributeValue("value");
        if (value == null) {
            throw new TemplateException("missing required attribute \"value\" for \"set\" tag");
        }
        Element parent = script.getParentElement();
        Element setTag = SetStmt.getElement(this.getName()).setAttribute("var", var).setAttribute("value", value);
        int index = parent.indexOf(script);
        parent.getContent().add(index, setTag);
        script.detach();
    }

    @Override
    public void execute(Processor<?> processor, Element tag, DataModel model) throws TemplateException {
        String var = tag.getAttributeValue("var");
        String valueExpression = tag.getAttributeValue("value");
        model.put(var, model.eval(valueExpression));
        tag.detach();
    }
}

