/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.odtemplate.statements;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.openconcerto.odtemplate.TemplateException;
import org.openconcerto.odtemplate.engine.DataModel;
import org.openconcerto.odtemplate.engine.Material;
import org.openconcerto.odtemplate.engine.Parsed;
import org.openconcerto.odtemplate.engine.Processor;
import org.openconcerto.odtemplate.statements.Statement;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cache.ICache;

public class Include
extends Statement {
    private static final String PREFIX = "[IOD";
    private final ICache<File, ODSingleXMLDocument, File> cache = new ICache(180);
    private final ICache<String, Parsed<ODSingleXMLDocument>, File> parsedCache = new ICache(180);

    public Include() {
        super("include");
    }

    @Override
    public boolean matches(Element elem) {
        if (!elem.getQualifiedName().equals("text:a")) {
            return false;
        }
        String name = Include.getName(elem);
        return name != null && name.startsWith(PREFIX);
    }

    private static String getName(Element elem) {
        return elem.getAttributeValue("name", elem.getNamespace("office"));
    }

    @Override
    public void prepare(Element script) {
        String href = script.getAttributeValue("href", script.getNamespace("xlink"));
        int sharp = href.indexOf(35);
        String path = href.substring(0, sharp);
        int pipe = href.lastIndexOf(124);
        int lastIndex = pipe < 0 ? href.lastIndexOf("%7C") : pipe;
        String section = href.substring(sharp + 1, lastIndex);
        String name = Include.getName(script);
        String paramS = name.substring(PREFIX.length(), name.lastIndexOf(93)).trim();
        Element param = paramS.length() > 0 ? new Element("param").setText(paramS) : null;
        script.removeContent();
        script.getAttributes().clear();
        script.setName(this.getName());
        script.setNamespace(stmtNS);
        script.setAttribute("path", path);
        script.setAttribute("section", section);
        if (param != null) {
            script.addContent(param);
        }
    }

    @Override
    public void execute(Processor<?> processor, Element tag, DataModel model) throws TemplateException {
        if (processor.getMaterial().getBase() == null) {
            throw new TemplateException("no base file for " + processor.getMaterial());
        }
        try {
            String relativePath = tag.getAttributeValue("path");
            File ref = new File(processor.getMaterial().getBase(), relativePath).getCanonicalFile();
            Parsed<ODSingleXMLDocument> parsed = this.getParsed(ref, tag.getAttributeValue("section"), processor.getParsed());
            ODSingleXMLDocument docExecuted = parsed.execute(this.getModel(model, tag));
            Object whole = processor.getMaterial().getWhole();
            ODSingleXMLDocument single = whole instanceof ODPackage ? (ODSingleXMLDocument)((ODPackage)whole).getContent() : (ODSingleXMLDocument)whole;
            single.replace(Include.getAncestorByName(tag, "p"), docExecuted);
        }
        catch (IOException e) {
            throw ExceptionUtils.createExn(TemplateException.class, "", e);
        }
        catch (JDOMException e) {
            throw ExceptionUtils.createExn(TemplateException.class, "", e);
        }
        tag.detach();
    }

    private Parsed<ODSingleXMLDocument> getParsed(File ref, String sectionName, Parsed<?> parsed) throws JDOMException, IOException, TemplateException {
        Parsed<ODSingleXMLDocument> res;
        String key = String.valueOf(ref.getPath()) + "#" + sectionName;
        CacheResult<Parsed<ODSingleXMLDocument>> cached = this.parsedCache.check(key);
        if (cached.getState() == CacheResult.State.NOT_IN_CACHE) {
            res = this.createParsed(ref, sectionName, parsed);
            this.parsedCache.put(key, res, Collections.emptySet());
        } else {
            res = cached.getRes();
        }
        return res;
    }

    private Parsed<ODSingleXMLDocument> createParsed(File ref, String sectionName, Parsed<?> parsed) throws JDOMException, IOException, TemplateException {
        ODSingleXMLDocument docToAdd = this.getXMLDocument(ref).clone();
        XPath sectionXP = docToAdd.getXPath("//text:section[@text:name = '" + sectionName + "']");
        Element section = (Element)sectionXP.selectSingleNode(docToAdd.getDocument());
        docToAdd.getBody().setContent(section.detach());
        Material<ODSingleXMLDocument> from = Material.from(docToAdd);
        from.setBase(ref);
        return new Parsed<ODSingleXMLDocument>(from, parsed);
    }

    private ODSingleXMLDocument getXMLDocument(File ref) throws JDOMException, IOException {
        ODSingleXMLDocument res;
        CacheResult<ODSingleXMLDocument> cached = this.cache.check(ref);
        if (cached.getState() == CacheResult.State.NOT_IN_CACHE) {
            res = ODSingleXMLDocument.createFromFile(ref);
            this.cache.put(ref, res, Collections.emptySet());
        } else {
            res = cached.getRes();
        }
        return res;
    }

    private DataModel getModel(DataModel dm, Element tag) throws TemplateException {
        DataModel res;
        Element param = tag.getChild("param");
        if (param != null) {
            res = dm.copy();
            res.eval(param.getText());
        } else {
            res = dm;
        }
        return res;
    }
}

