/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.odtemplate.statements;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.openconcerto.odtemplate.TemplateException;
import org.openconcerto.odtemplate.engine.DataModel;
import org.openconcerto.odtemplate.engine.Processor;
import org.openconcerto.odtemplate.statements.BaseStatement;

public class If
extends BaseStatement {
    public If() {
        super("if");
    }

    @Override
    public void prepare(Element script, Element command) throws TemplateException {
        String elementName = command.getAttributeValue("element");
        if (elementName == null) {
            throw new TemplateException("missing required attribute for if tag: element");
        }
        String testExpression = command.getAttributeValue("test");
        if (testExpression == null) {
            throw new TemplateException("missing required attribute for if tag: test");
        }
        Element target = If.getAncestorByName(script, elementName);
        if (target == null) {
            throw new TemplateException("no such element enclosing if tag: " + elementName + " for expression: " + testExpression);
        }
        Element parent = target.getParentElement();
        Element ifTag = If.getElement(this.getName()).setAttribute("test", testExpression);
        int index = parent.indexOf(target);
        target.detach();
        parent.getContent().add(index, ifTag);
        ifTag.addContent(target);
        script.detach();
    }

    public void execute(Processor processor, Element tag, DataModel model) throws TemplateException {
        Object value;
        String testExpression = tag.getAttributeValue("test");
        if (testExpression != null && Boolean.TRUE.equals(value = model.eval(testExpression))) {
            List parentContent = tag.getParentElement().getContent();
            int index = parentContent.indexOf(tag);
            ArrayList children = new ArrayList(tag.getChildren());
            parentContent.addAll(index, tag.removeContent());
            for (Element target : children) {
                processor.transform(target);
                If.removeSection(target);
            }
        }
        tag.detach();
    }
}

