/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.odtemplate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openconcerto.odtemplate.TemplateException;
import org.openconcerto.odtemplate.engine.DataModel;
import org.openconcerto.odtemplate.engine.Material;
import org.openconcerto.odtemplate.engine.Parsed;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODSingleXMLDocument;

public class Template {
    protected final Parsed<ODPackage> contentTemplate;

    public Template(InputStream in) throws IOException, TemplateException {
        this(new ODPackage(in));
    }

    public Template(File f) throws IOException, TemplateException {
        this(new ODPackage(f));
    }

    public Template(ODPackage contents) throws IOException, TemplateException {
        contents.toSingle();
        this.contentTemplate = new Parsed<ODPackage>(Material.from(contents));
    }

    public void createDocument(DataModel engine, OutputStream out) throws IOException, TemplateException {
        this.execute(engine).save(out);
    }

    public ODSingleXMLDocument createDocument(DataModel engine) throws TemplateException {
        return (ODSingleXMLDocument)this.execute(engine).getContent();
    }

    private ODPackage execute(DataModel engine) throws TemplateException {
        return this.contentTemplate.execute(engine);
    }
}

