/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.Predicate;
import org.openconcerto.map.model.Ville;
import org.openconcerto.map.ui.ITextComboCacheVille;
import org.openconcerto.map.ui.MapViewerPanel;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.ITextSelector;
import org.openconcerto.ui.component.text.DocumentComponent;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObject;
import org.openconcerto.utils.checks.EmptyObjectHelper;
import org.openconcerto.utils.checks.ValidListener;

public class ITextComboVilleViewer
extends JPanel
implements ValueWrapper<String>,
DocumentComponent,
TextComponent,
EmptyObject {
    private static final long serialVersionUID = 3397210337907076649L;
    private final ITextSelector text = new ITextSelector(ComboLockedMode.ITEMS_LOCKED);
    private final JButton button = new JButton("Afficher sur la carte");
    private Ville currentVille = null;
    private final EmptyObjectHelper emptyHelper;
    private final ValueChangeSupport<String> supp;
    private final ITextComboCacheVille cache;

    public ITextComboVilleViewer() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.supp = new ValueChangeSupport<String>(this);
        this.emptyHelper = new EmptyObjectHelper(this, new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                return ITextComboVilleViewer.this.getValue() == null || ITextComboVilleViewer.this.getValue().trim().length() == 0;
            }
        });
        this.text.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ITextComboVilleViewer.this.supp.fireValueChange();
            }
        });
        this.cache = new ITextComboCacheVille();
        this.text.initCache(this.cache);
        this.add((Component)this.text, "Center");
        this.add((Component)this.button, "East");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame();
                MapViewerPanel mapViewerPanel = new MapViewerPanel(true);
                f.setContentPane(mapViewerPanel);
                f.setDefaultCloseOperation(2);
                f.setSize(600, 500);
                f.setMinimumSize(new Dimension(600, 500));
                File conf = new File(System.getProperty("user.home"), ".java" + File.separator + "ilm" + File.separator + "map" + File.separator);
                new WindowStateManager(f, new File(conf, "Configuration" + File.separator + "MapFrame.properties"), true).loadState();
                f.setVisible(true);
                if (ITextComboVilleViewer.this.currentVille != null) {
                    long x = ITextComboVilleViewer.this.currentVille.getXLambert();
                    long y = ITextComboVilleViewer.this.currentVille.getYLambert();
                    f.setTitle(ITextComboVilleViewer.this.currentVille.getName());
                    mapViewerPanel.getVilleRendererPanel().centerScreenXYLambert(x, y);
                    mapViewerPanel.getVilleRendererPanel().setHighlight(ITextComboVilleViewer.this.currentVille);
                    mapViewerPanel.getVilleRendererPanel().setAlwayVisible(ITextComboVilleViewer.this.currentVille);
                }
            }
        });
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ITextComboVilleViewer.this.currentVille = Ville.getVilleFromVilleEtCode(ITextComboVilleViewer.this.text.getValue());
                ITextComboVilleViewer.this.button.setEnabled(ITextComboVilleViewer.this.currentVille != null && ITextComboVilleViewer.this.isEnabled());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }
        });
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Enregistrer cette ville");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String t = ITextComboVilleViewer.this.text.getTextComp().getText();
                ITextComboVilleViewer.this.cache.addToCache(t);
                Ville createVilleFrom = ITextComboVilleViewer.this.cache.createVilleFrom(t);
                if (createVilleFrom != null) {
                    String villeEtCode = createVilleFrom.getVilleEtCode();
                    ITextComboVilleViewer.this.setValue(villeEtCode);
                    ITextComboVilleViewer.this.firePropertyChange("value", null, villeEtCode);
                }
            }
        });
        popupMenu.add(menuItem);
        this.text.getTextComp().addMouseListener(new MouseAdapter(){

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }
        });
    }

    @Override
    public void addEmptyListener(EmptyListener l) {
        this.emptyHelper.addListener(l);
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public Document getDocument() {
        return this.text.getDocument();
    }

    @Override
    public JTextComponent getTextComp() {
        return this.text.getTextComp();
    }

    @Override
    public Object getUncheckedValue() {
        return this.getValue();
    }

    @Override
    public String getValidationText() {
        return String.valueOf(this.getValue()) + " n'existe pas";
    }

    @Override
    public String getValue() {
        return this.text.getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.emptyHelper.isEmpty();
    }

    @Override
    public boolean isValidated() {
        boolean b;
        Ville villeFromVilleEtCode = Ville.getVilleFromVilleEtCode(this.getValue());
        boolean bl = b = villeFromVilleEtCode != null;
        if (b) {
            this.cache.setLastGood(villeFromVilleEtCode);
        }
        return b;
    }

    @Override
    public void resetValue() {
        this.text.resetValue();
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }

    public void setButtonVisible(boolean b) {
        this.button.setVisible(b);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.text.setEditable(enabled);
        this.button.setEnabled(enabled);
    }

    @Override
    public void setValue(String val) {
        this.text.setValue(val);
    }
}

