/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.laf;

import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class IComboBoxUI
extends MetalComboBoxUI {
    static int comboBoxButtonSize = 19;

    public static ComponentUI createUI(JComponent c) {
        return new IComboBoxUI();
    }

    @Override
    public void layoutComboBox(Container parent, MetalComboBoxUI.MetalComboBoxLayoutManager manager) {
        if (this.arrowButton != null) {
            Icon icon = this.arrowButton.getIcon();
            Insets buttonInsets = this.arrowButton.getInsets();
            Insets insets = this.comboBox.getInsets();
            int buttonWidth = icon.getIconWidth() + buttonInsets.left + buttonInsets.right;
            this.arrowButton.setBounds(this.comboBox.getWidth() - insets.right - buttonWidth, insets.top, buttonWidth, this.comboBox.getHeight() - insets.top - insets.bottom);
        } else {
            Insets insets = this.comboBox.getInsets();
            int width = this.comboBox.getWidth();
            int height = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
        }
        if (this.editor != null) {
            Rectangle cvb = this.rectangleForCurrentValue();
            this.editor.setBounds(cvb);
        }
    }

    @Override
    protected JButton createArrowButton() {
        JButton button = new JButton(new ImageIcon(this.getClass().getResource("comboright.png")));
        button.setBackground(new Color(239, 235, 231));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorderPainted(false);
        button.setBorder(null);
        return button;
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return new XPPropertyChangeListener();
    }

    @Override
    protected void editablePropertyChanged(PropertyChangeEvent e) {
    }

    public class XPPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public XPPropertyChangeListener() {
            super(IComboBoxUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName.equals("editable")) {
                JButton button = IComboBoxUI.this.arrowButton;
                IComboBoxUI.this.comboBox.repaint();
            } else if (propertyName.equals("background")) {
                Color color = (Color)e.getNewValue();
                IComboBoxUI.this.listBox.setBackground(color);
            } else if (propertyName.equals("foreground")) {
                Color color = (Color)e.getNewValue();
                IComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }
}

