/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ftp;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.io.CopyStreamAdapter;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.io.Util;
import org.openconcerto.ftp.CopyFileListener;
import org.openconcerto.ftp.FTPUtils;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.MessageDigestUtils;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.StringInputStream;
import org.openconcerto.utils.cc.ExnClosure;

public class IFtp
extends FTPClient {
    private static final String MD5_SUFFIX = ".md5";
    private static final int MD5_LENGTH = 32;
    private final ThreadLocal<CopyStreamListener> streamListeners = new ThreadLocal();

    private static final String md5ToName(String fname, String md5) {
        if (md5.length() != 32) {
            throw new IllegalArgumentException("md5 size must be 32 : " + md5);
        }
        return String.valueOf(fname) + "_" + md5 + MD5_SUFFIX;
    }

    @Override
    public boolean login(String username, String password) throws IOException {
        boolean res = super.login(username, password);
        this.setFileType(2);
        return res;
    }

    public List<File> sync(File lDir) throws IOException, NoSuchAlgorithmException {
        return this.sync(lDir, null);
    }

    public List<File> sync(File lDir, CopyFileListener l) throws IOException, NoSuchAlgorithmException {
        return this.sync(lDir, l, false);
    }

    public List<File> sync(File ldir, final CopyFileListener l, boolean forceUpload) throws IOException, NoSuchAlgorithmException {
        CollectionMap nameToMD5s = new CollectionMap();
        HashMap<String, FTPFile> ftpFiles = new HashMap<String, FTPFile>();
        FTPFile[] listFiles = this.listFiles();
        if (listFiles == null) {
            System.out.println("IFtp.sync(): listFiles null :" + ldir.getName());
            return new ArrayList<File>();
        }
        int i = 0;
        while (i < listFiles.length) {
            FTPFile rFile = listFiles[i];
            if (rFile != null) {
                String name = rFile.getName();
                if (name != null) {
                    if (name.endsWith(MD5_SUFFIX)) {
                        int underscore = name.length() - MD5_SUFFIX.length() - 32 - 1;
                        if (underscore >= 0) {
                            String fname = name.substring(0, underscore);
                            String md5 = name.substring(underscore + 1, underscore + 1 + 32);
                            nameToMD5s.put(fname, md5);
                        }
                    } else {
                        ftpFiles.put(name, rFile);
                    }
                } else {
                    System.out.println("IFtp.sync(): rFile.getName() null : [" + i + "]" + ldir.getName());
                }
            } else {
                System.out.println("IFtp.sync(): rFile null : [" + i + "]" + ldir.getName());
            }
            ++i;
        }
        ArrayList<File> uploaded = new ArrayList<File>();
        ArrayList<File> dirs = new ArrayList<File>();
        File[] fileArray = ldir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            final File lFile = fileArray[n2];
            if (lFile.isFile() && lFile.canRead()) {
                String lName = lFile.getName();
                List md5List = (List)nameToMD5s.getNonNull(lName);
                String lMD5 = MessageDigestUtils.getMD5(lFile);
                boolean shouldUpload = true;
                if (!forceUpload && ftpFiles.containsKey(lFile.getName())) {
                    long rSize;
                    long lSize = lFile.length();
                    boolean bl = shouldUpload = lSize != (rSize = ((FTPFile)ftpFiles.get(lFile.getName())).getSize()) || !lMD5.equalsIgnoreCase((String)CollectionUtils.getSole(md5List));
                }
                if (shouldUpload) {
                    for (String md5 : md5List) {
                        this.deleteFile(IFtp.md5ToName(lName, md5));
                    }
                    if (l != null) {
                        final long fileSize = lFile.length();
                        this.streamListeners.set(new CopyStreamAdapter(){

                            @Override
                            public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                                l.bytesTransferred(lFile, totalBytesTransferred, bytesTransferred, fileSize);
                            }
                        });
                    }
                    this.storeFile(lName, new FileInputStream(lFile));
                    this.streamListeners.set(null);
                    this.storeFile(IFtp.md5ToName(lName, lMD5), new StringInputStream(String.valueOf(lMD5) + "\t" + lName));
                    uploaded.add(lFile);
                }
            } else if (lFile.isDirectory()) {
                dirs.add(lFile);
            }
            ++n2;
        }
        for (File dir : dirs) {
            this.makeDirectory(dir.getName());
            if (!this.changeWorkingDirectory(dir.getName())) {
                throw new IllegalStateException("could not cd to " + dir.getName());
            }
            uploaded.addAll(this.sync(dir, l, forceUpload));
            this.changeToParentDirectory();
        }
        return uploaded;
    }

    public final void saveR(File local) throws IOException {
        FTPUtils.saveR(this, local);
    }

    public void rmR(String toRm) throws IOException {
        FTPUtils.rmR(this, toRm);
    }

    public final void recurse(ExnClosure<FTPFile, ?> c) throws IOException {
        this.recurse(c, RecursionType.DEPTH_FIRST);
    }

    public final void recurse(ExnClosure<FTPFile, ?> c, RecursionType type) throws IOException {
        FTPUtils.recurse(this, c, type);
    }

    private boolean __storeFile(int command, String remote, InputStream local) throws IOException {
        Socket socket = this._openDataConnection_(command, remote);
        if (socket == null) {
            return false;
        }
        BufferedOutputStream output = new BufferedOutputStream(socket.getOutputStream(), this.getBufferSize());
        try {
            CopyStreamListener l = this.streamListeners.get();
            long size = -1L;
            if (l != null) {
                l.bytesTransferred(0L, 0, -1L);
            }
            Util.copyStream(local, output, this.getBufferSize(), -1L, l, false);
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        ((OutputStream)output).close();
        socket.close();
        return this.completePendingCommand();
    }

    @Override
    public boolean storeFile(String remote, InputStream local) throws IOException {
        return this.__storeFile(14, remote, local);
    }

    @Override
    public boolean appendFile(String remote, InputStream local) throws IOException {
        return this.__storeFile(16, remote, local);
    }

    @Override
    public boolean storeUniqueFile(String remote, InputStream local) throws IOException {
        return this.__storeFile(15, remote, local);
    }

    @Override
    public boolean storeUniqueFile(InputStream local) throws IOException {
        return this.__storeFile(15, null, local);
    }
}

