/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.map.model.DatabaseAccessor;
import org.openconcerto.map.model.Ville;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;

public class NXDatabaseAccessor
implements DatabaseAccessor {
    @Override
    public List<Ville> read() {
        SQLTable ville = Configuration.getInstance().getBase().getTable("VILLE");
        SQLSelect sel = new SQLSelect(Configuration.getInstance().getBase());
        sel.addSelectStar(ville);
        List l = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        ArrayList<Ville> lResult = new ArrayList<Ville>();
        for (SQLRow row : l) {
            String nom = row.getString("NOM");
            String cp = row.getString("CODE_POSTAL");
            long pop = ((Number)row.getObject("POPULATION")).longValue();
            long x = ((Number)row.getObject("X_LAMBERT")).longValue();
            long y = ((Number)row.getObject("Y_LAMBERT")).longValue();
            Ville v = new Ville(nom, pop, x, y, cp);
            lResult.add(v);
        }
        return lResult;
    }

    @Override
    public void store(Ville v) {
        SQLTable ville = Configuration.getInstance().getBase().getTable("VILLE");
        SQLRowValues rowVals = new SQLRowValues(ville);
        rowVals.put("NOM", v.getName());
        rowVals.put("CODE_POSTAL", v.getCodepostal());
        rowVals.put("X_LAMBERT", v.getXLambert());
        rowVals.put("Y_LAMBERT", v.getYLambert());
        rowVals.put("POPULATION", v.getPopulation());
        try {
            rowVals.insert();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

