/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;

public class FileUtility {
    public static String getPrimaryPath(File ref, File access) {
        String name;
        String path = "";
        ArrayList<String> refp = new ArrayList<String>();
        File cur = ref;
        while (cur != null) {
            String name2 = cur.getName();
            if (name2.length() == 0) {
                name2 = cur.getAbsolutePath();
            }
            refp.add(name2);
            cur = cur.getParentFile();
        }
        ArrayList<String> accp = new ArrayList<String>();
        File cur2 = access;
        while (cur2 != null) {
            name = cur2.getName();
            if (name.length() == 0) {
                name = cur2.getAbsolutePath();
            }
            accp.add(name);
            cur2 = cur2.getParentFile();
        }
        if (refp.size() == 0 || accp.size() == 0) {
            return path;
        }
        if (((String)refp.get(refp.size() - 1)).equals(accp.get(accp.size() - 1))) {
            boolean equal = true;
            while (equal && refp.size() > 1 && accp.size() > 1) {
                refp.remove(refp.size() - 1);
                accp.remove(accp.size() - 1);
                equal = ((String)refp.get(refp.size() - 1)).equals(accp.get(accp.size() - 1));
            }
            if (refp.size() == 1) {
                if (!equal) {
                    refp.remove(refp.size() - 1);
                    path = String.valueOf(path) + "..";
                } else {
                    refp.remove(refp.size() - 1);
                    accp.remove(accp.size() - 1);
                    path = String.valueOf(path) + ".";
                }
            } else {
                if (equal && accp.size() == 1) {
                    refp.remove(refp.size() - 1);
                    accp.remove(accp.size() - 1);
                }
                while (refp.size() > 0) {
                    refp.remove(refp.size() - 1);
                    path = String.valueOf(path) + "..";
                    if (refp.size() <= 0) continue;
                    path = String.valueOf(path) + File.separator;
                }
            }
            while (accp.size() > 0) {
                name = (String)accp.remove(accp.size() - 1);
                path = String.valueOf(path) + File.separator;
                path = String.valueOf(path) + name;
            }
        } else {
            try {
                path = access.getCanonicalPath();
            }
            catch (IOException e) {
                path = access.getAbsolutePath();
                e.printStackTrace();
            }
        }
        return path;
    }

    public static String getRelativePathOfAbsolutePath(String absolutePath, String pathRef) {
        String absoluteRefPath = new File(FileUtility.getSlashTerminatedPath(pathRef)).getAbsolutePath();
        absoluteRefPath = FileUtility.removeDotDotInPath(absoluteRefPath);
        absolutePath = absolutePath.replace('\\', '/');
        absoluteRefPath = absoluteRefPath.replace('\\', '/');
        if ((absolutePath = FileUtility.getSlashTerminatedPath(absolutePath)).compareTo(absoluteRefPath = FileUtility.getSlashTerminatedPath(absoluteRefPath)) == 0) {
            return FileUtility.getSlashTerminatedPath(pathRef);
        }
        if (absolutePath.indexOf(absoluteRefPath) == -1) {
            return absolutePath;
        }
        return absolutePath.substring(absoluteRefPath.length());
    }

    private static String getSlashTerminatedPath(String path) {
        if (path.equals("")) {
            return "";
        }
        return path.endsWith("/") || path.endsWith("\\") ? path : String.valueOf(path) + "/";
    }

    private static String removeDotDotInPath(String path) {
        Stack<String> dirs = new Stack<String>();
        int pos = 0;
        int newPos = 0;
        String formattedPath = "";
        path = path.replace('\\', '/');
        pos = (path = FileUtility.getSlashTerminatedPath(path)).indexOf("/");
        if (pos == -1) {
            return path;
        }
        if (pos == 0) {
            formattedPath = "/";
            pos = 1;
        } else {
            pos = 0;
        }
        while (newPos != -1) {
            newPos = path.indexOf("/", pos);
            if (newPos != -1) {
                String newDir = path.substring(pos, newPos);
                if (newDir.compareTo("..") == 0) {
                    dirs.pop();
                } else {
                    dirs.push(newDir);
                }
                pos = newPos;
            }
            ++pos;
        }
        Object[] dirsArray = dirs.toArray();
        int i = 0;
        while (i < dirsArray.length) {
            formattedPath = String.valueOf(formattedPath) + (i != 0 ? "/" : "") + dirsArray[i].toString();
            ++i;
        }
        return String.valueOf(formattedPath) + "/";
    }
}

