/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.openconcerto.sql.Configuration;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;
import org.openconcerto.utils.ExceptionHandler;

public class DefaultLocalPreferencePanel
extends DefaultPreferencePanel {
    private final String title;
    private final String fileName;
    protected final Properties properties = new Properties();

    public DefaultLocalPreferencePanel(String title, String fileName) {
        this.title = title;
        this.fileName = fileName;
        if (this.getPrefFile().exists()) {
            try {
                FileInputStream fIp = new FileInputStream(this.getPrefFile());
                this.properties.load(new BufferedInputStream(fIp));
                fIp.close();
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de lire les pr\u00e9f\u00e9rences pour " + this.getTitleName(), e);
            }
        }
    }

    @Override
    public void storeValues() {
        try {
            FileOutputStream fOp = new FileOutputStream(this.getPrefFile());
            this.properties.store(new BufferedOutputStream(fOp), this.getTitleName());
            fOp.close();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de sauvegarde les pr\u00e9f\u00e9rences pour " + this.getTitleName(), e);
        }
    }

    @Override
    public void restoreToDefaults() {
        this.properties.clear();
    }

    @Override
    public String getTitleName() {
        return this.title;
    }

    private File getPrefFile() {
        return DefaultLocalPreferencePanel.getPrefFile(this.fileName);
    }

    public static File getPrefFile(String fileName) {
        return new File(Configuration.getInstance().getConfDir(), "/Configuration/" + fileName);
    }
}

