/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.panel.PostgreSQLFrame;
import org.openconcerto.erp.preferences.BackupNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.utils.BackupPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class UserExitPanel
extends JPanel {
    PostgreSQLFrame pgFrame = null;

    public UserExitPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.anchor = 10;
        c.insets = new Insets(2, 2, 5, 2);
        c.weightx = 1.0;
        c.gridwidth = 2;
        JLabel labelQuit = new JLabel("Voulez-vous vraiment quitter " + Configuration.getInstance().getAppName() + " ?");
        JButton buttonCancel = new JButton("Annuler");
        JButton buttonBackup = new JButton("Sauvegarder et quitter");
        JButton buttonExit = new JButton("Quitter");
        this.add((Component)labelQuit, c);
        ++c.gridy;
        c.fill = 0;
        c.gridwidth = 1;
        this.add((Component)buttonExit, c);
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        if (comptaPropsConfiguration.getSocieteID() > 1) {
            ++c.gridx;
            this.add((Component)buttonBackup, c);
        }
        ++c.gridx;
        this.add((Component)buttonCancel, c);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.getWindowAncestor(UserExitPanel.this).dispose();
            }
        });
        ActionListener listenerExit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserExitPanel.this.closeGNx();
            }
        };
        buttonBackup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog frame = new JDialog();
                frame.setContentPane(new BackupPanel(Arrays.asList("Common", ((ComptaPropsConfiguration)Configuration.getInstance()).getSocieteBaseName()), Arrays.asList(new File("./2010"), ((ComptaPropsConfiguration)Configuration.getInstance()).getDataDir()), false, BackupNXProps.getInstance()){

                    @Override
                    public void doOnClose() {
                        super.doOnClose();
                        UserExitPanel.this.closeGNx();
                    }
                });
                frame.setTitle("Sauvegarde des donn\u00e9es");
                frame.setDefaultCloseOperation(2);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        UserExitPanel.this.startTimeOut();
                    }
                });
                frame.setLocationRelativeTo(null);
                frame.pack();
                frame.setMinimumSize(frame.getSize());
                ((Window)SwingUtilities.getRoot(UserExitPanel.this)).dispose();
                frame.setModal(true);
                frame.setIconImages(Gestion.getFrameIcon());
                frame.setAlwaysOnTop(true);
                frame.setVisible(true);
            }
        });
        buttonExit.addActionListener(listenerExit);
    }

    private void closeGNx() {
        Frame[] frames = JFrame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i] != null) {
                frames[i].dispose();
            }
            ++i;
        }
        ComptaPropsConfiguration.closeOOConnexion();
        if (Gestion.pgFrameStart != null) {
            Gestion.pgFrameStart.setVisible(false);
        }
        new Thread(){

            @Override
            public void run() {
                block7: {
                    try {
                        Runtime runtime = Runtime.getRuntime();
                        File f = new File(".\\PostgreSQL\\bin\\");
                        if (f.exists()) {
                            final Process p = runtime.exec(new String[]{"cmd.exe", "/C", "stopPostGres.bat"}, null, f);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        (this).UserExitPanel.this.pgFrame = new PostgreSQLFrame("Arr\u00eat en cours");
                                        (this).UserExitPanel.this.pgFrame.setVisible(true);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                            System.err.println("Execute end postgres");
                            new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                                        String line = "";
                                        try {
                                            while ((line = reader.readLine()) != null) {
                                                System.out.println(line);
                                            }
                                        }
                                        finally {
                                            reader.close();
                                        }
                                    }
                                    catch (IOException ioe) {
                                        ioe.printStackTrace();
                                    }
                                }
                            }.start();
                            new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                                        String line = "";
                                        try {
                                            while ((line = reader.readLine()) != null) {
                                                System.err.println(line);
                                            }
                                        }
                                        finally {
                                            reader.close();
                                        }
                                    }
                                    catch (IOException ioe) {
                                        ioe.printStackTrace();
                                    }
                                }
                            }.start();
                            p.waitFor();
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).UserExitPanel.this.pgFrame != null) {
                                    (this).UserExitPanel.this.pgFrame.dispose();
                                }
                            }
                        });
                        UserExitPanel.this.startTimeOut();
                        break block7;
                    }
                    catch (InterruptedException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            UserExitPanel.this.startTimeOut();
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        UserExitPanel.this.startTimeOut();
                        break block7;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    UserExitPanel.this.startTimeOut();
                }
            }
        }.start();
    }

    private final void startTimeOut() {
        Thread timeOut = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(120000L);
                    System.err.println("Warning: Forcing exit");
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Configuration.getInstance().destroy();
                        }
                    });
                    t.setDaemon(true);
                    t.setName("Configuration destroy");
                    t.start();
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.exit(1);
            }
        });
        timeOut.setName("TimeOut Thread");
        timeOut.setDaemon(true);
        timeOut.start();
    }
}

