/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.utils.cc.IFactory;

public class ModuleTableModel
extends AbstractTableModel {
    private static final int CB_INDEX = 0;
    private final IFactory<? extends Collection<ModuleFactory>> rowSource;
    protected List<ModuleFactory> list;
    private final Set<ModuleFactory> selection;

    public ModuleTableModel(IFactory<? extends Collection<ModuleFactory>> rowSource) {
        this.rowSource = rowSource;
        this.selection = new HashSet<ModuleFactory>();
        this.reload();
    }

    public final void reload() {
        this.list = new ArrayList<ModuleFactory>(this.rowSource.createChecked());
        Collections.sort(this.list, new Comparator<ModuleFactory>(){

            @Override
            public int compare(ModuleFactory o1, ModuleFactory o2) {
                return o1.getID().compareTo(o2.getID());
            }
        });
        this.selection.retainAll(this.list);
        this.fireTableDataChanged();
    }

    public final Collection<ModuleFactory> getCheckedRows() {
        return Collections.unmodifiableSet(this.selection);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 1) {
            return "Nom";
        }
        if (column == 2) {
            return "Version";
        }
        if (column == 3) {
            return "Etat";
        }
        return "";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            try {
                return this.list.get(rowIndex).getName();
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if (columnIndex == 2) {
            try {
                return this.list.get(rowIndex).getVersion();
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if (columnIndex == 3) {
            return ModuleManager.getInstance().isModuleRunning(this.list.get(rowIndex).getID()) ? "Actif" : "Inactif";
        }
        if (columnIndex == 0) {
            return this.selection.contains(this.list.get(rowIndex));
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (((Boolean)value).booleanValue()) {
                this.selection.add(this.list.get(rowIndex));
            } else {
                this.selection.remove(this.list.get(rowIndex));
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }
}

