/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.utils.cc.IPredicate;

public abstract class ModuleFactory {
    public static final String NAME_KEY = "name";
    public static final String DESC_KEY = "description";
    private static final Pattern javaIdentifiedPatrn = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final Pattern qualifiedPatrn;
    private static final Pattern idPatrn;
    private static final Pattern versionPatrn;
    private static final Pattern dependsSplitPatrn;
    private static final Pattern dependsPatrn;
    private final String id;
    private final ModuleVersion version;
    private final String contact;
    private final Map<String, IPredicate<ModuleFactory>> dependsPredicates;
    private final String mainClass;
    private ResourceBundle rsrcBundle;

    static {
        idPatrn = qualifiedPatrn = Pattern.compile(String.valueOf(javaIdentifiedPatrn.pattern()) + "(\\." + javaIdentifiedPatrn.pattern() + ")*");
        versionPatrn = Pattern.compile("(\\p{Digit}+)(?:\\.(\\p{Digit}+))?");
        dependsSplitPatrn = Pattern.compile("\\p{Blank}*,\\p{Blank}+");
        dependsPatrn = Pattern.compile("(" + idPatrn.pattern() + ")(?:\\p{Blank}+\\( *(" + versionPatrn.pattern() + ") *\\))?");
    }

    protected static Properties readAndClose(InputStream ins) throws IOException {
        Properties props = new Properties();
        try {
            props.load(ins);
        }
        finally {
            ins.close();
        }
        return props;
    }

    protected static final String getRequiredProp(Properties props, String key) {
        String res = props.getProperty(key);
        if (res == null) {
            throw new IllegalStateException("Missing " + key);
        }
        return res;
    }

    private static String checkMatch(Pattern p, String s, String name) {
        if (!p.matcher(s).matches()) {
            throw new IllegalArgumentException(String.valueOf(name) + " doesn't match " + p.pattern());
        }
        return s;
    }

    private static final int parseInt(Matcher m, int group) {
        String s = m.group(group);
        return s == null ? 0 : Integer.parseInt(s);
    }

    private static final ModuleVersion getVersion(Matcher m, int offset) {
        return new ModuleVersion(ModuleFactory.parseInt(m, offset + 1), ModuleFactory.parseInt(m, offset + 2));
    }

    protected ModuleFactory(Properties props) throws IOException {
        this.id = ModuleFactory.checkMatch(idPatrn, ModuleFactory.getRequiredProp(props, "id").trim(), "ID");
        String version = ModuleFactory.getRequiredProp(props, "version").trim();
        Matcher versionMatcher = versionPatrn.matcher(version);
        if (!versionMatcher.matches()) {
            throw new IllegalArgumentException("Version doesn't match " + versionPatrn.pattern());
        }
        this.version = ModuleFactory.getVersion(versionMatcher, 0);
        this.contact = ModuleFactory.getRequiredProp(props, "contact");
        String depends = props.getProperty("depends", "").trim();
        String[] dependsArray = depends.length() == 0 ? new String[]{} : dependsSplitPatrn.split(depends);
        this.dependsPredicates = new HashMap<String, IPredicate<ModuleFactory>>(dependsArray.length);
        String[] stringArray = dependsArray;
        int n = dependsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String depend = stringArray[n2];
            Matcher dependMatcher = dependsPatrn.matcher(depend);
            if (!dependMatcher.matches()) {
                throw new IllegalArgumentException("'" + depend + "' doesn't match " + dependsPatrn.pattern());
            }
            final ModuleVersion depVersion = ModuleFactory.getVersion(dependMatcher, 2);
            this.dependsPredicates.put(dependMatcher.group(1), new IPredicate<ModuleFactory>(){

                @Override
                public boolean evaluateChecked(ModuleFactory input) {
                    return input.getVersion().compareTo(depVersion) >= 0;
                }
            });
            ++n2;
        }
        String entryPoint = ModuleFactory.checkMatch(javaIdentifiedPatrn, props.getProperty("entryPoint", "Module"), "Entry point");
        this.mainClass = String.valueOf(this.id) + "." + entryPoint;
        this.rsrcBundle = null;
    }

    public final String getID() {
        return this.id;
    }

    public final String getContact() {
        return this.contact;
    }

    public final ModuleVersion getVersion() {
        return this.version;
    }

    public final int getMajorVersion() {
        return this.version.getMajor();
    }

    public final int getMinorVersion() {
        return this.version.getMinor();
    }

    protected final String getMainClass() {
        return this.mainClass;
    }

    public final Collection<String> getRequiredIDs() {
        return this.dependsPredicates.keySet();
    }

    public final boolean isRequiredFactoryOK(ModuleFactory f) {
        return this.dependsPredicates.get(f.getID()).evaluateChecked(f);
    }

    protected final ResourceBundle getResourceBundle() {
        if (this.rsrcBundle == null) {
            this.rsrcBundle = ResourceBundle.getBundle(String.valueOf(this.getID()) + ".ModuleResources", Locale.getDefault(), this.getRsrcClassLoader(), ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
        }
        return this.rsrcBundle;
    }

    protected abstract ClassLoader getRsrcClassLoader();

    public final String getName() {
        return this.getResourceBundle().getString(NAME_KEY);
    }

    public final String getDescription() {
        return this.getResourceBundle().getString(DESC_KEY);
    }

    public abstract AbstractModule createModule(Map<String, AbstractModule> var1) throws Exception;

    protected final AbstractModule createModule(Class<?> c) throws Exception {
        return (AbstractModule)c.getConstructor(ModuleFactory.class).newInstance(this);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.getID() + " (" + this.getMajorVersion() + "." + this.getMinorVersion() + ")";
    }
}

