/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ModuleFactory;

public final class JarModuleFactory
extends ModuleFactory {
    private final File jar;

    private static Properties getProperties(File jar) throws IOException {
        JarFile jarFile = new JarFile(jar);
        return JarModuleFactory.readAndClose(jarFile.getInputStream(jarFile.getEntry("META-INF/openConcertoModule.properties")));
    }

    public JarModuleFactory(File jar) throws IOException {
        super(JarModuleFactory.getProperties(jar));
        this.jar = jar;
    }

    protected final URL[] getClassPath() {
        try {
            return new URL[]{this.jar.toURI().toURL()};
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected ClassLoader getRsrcClassLoader() {
        return new URLClassLoader(this.getClassPath()){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                throw new ClassNotFoundException(String.valueOf(name) + " is hidden from this loader, it only loads properties");
            }
        };
    }

    @Override
    public AbstractModule createModule(Map<String, AbstractModule> alreadyCreated) throws Exception {
        return this.createModule(new ModuleClassLoader(alreadyCreated).loadClass(this.getMainClass()));
    }

    private final class ModuleClassLoader
    extends URLClassLoader {
        private final ClassLoader[] dependencies;

        public ModuleClassLoader(Map<String, AbstractModule> alreadyCreated) {
            super(JarModuleFactory.this.getClassPath(), JarModuleFactory.class.getClassLoader());
            this.dependencies = new ClassLoader[JarModuleFactory.this.getRequiredIDs().size()];
            int i = 0;
            for (String requiredID : JarModuleFactory.this.getRequiredIDs()) {
                AbstractModule m = alreadyCreated.get(requiredID);
                if (m == null) {
                    throw new IllegalStateException("Missing required module : " + requiredID);
                }
                this.dependencies[i++] = m.getClass().getClassLoader();
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException var3_3) {
                var6_5 = this.dependencies;
                var5_6 = this.dependencies.length;
                var4_7 = 0;
                ** while (var4_7 < var5_6)
            }
lbl-1000:
            // 1 sources

            {
                cl = var6_5[var4_7];
                try {
                    res = cl.loadClass(name);
                    if (resolve) {
                        this.resolveClass(res);
                    }
                    return res;
                }
                catch (ClassNotFoundException var7_8) {
                    ++var4_7;
                }
                continue;
            }
lbl17:
            // 1 sources

            throw new ClassNotFoundException(name);
        }
    }
}

