/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.erp.modules.AlterTableRestricted;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.DropTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.utils.CollectionMap;

public final class DBContext {
    private final ModuleVersion lastInstalledVersion;
    private final DBRoot root;
    private final List<ChangeTable<?>> changeTables;
    private final List<AlterTableRestricted> alterTables;
    private final Set<String> tables;
    private final CollectionMap<String, SQLField> fields;

    DBContext(ModuleVersion lastInstalledVersion, DBRoot root, Set<String> tables, Set<SQLName> fields) {
        this.lastInstalledVersion = lastInstalledVersion;
        this.root = root;
        this.tables = Collections.unmodifiableSet(tables);
        this.fields = new CollectionMap(new HashSet());
        for (SQLName f : fields) {
            String tableName = f.getItem(0);
            this.fields.put((Object)tableName, (Object)this.root.getTable(tableName).getField(f.getItem(1)));
        }
        this.changeTables = new ArrayList();
        this.alterTables = new ArrayList<AlterTableRestricted>();
    }

    public final ModuleVersion getLastInstalledVersion() {
        return this.lastInstalledVersion;
    }

    public final DBRoot getRoot() {
        return this.root;
    }

    public final Set<String> getTablesPreviouslyCreated() {
        return this.tables;
    }

    public final Set<SQLField> getFieldsPreviouslyCreated(String tableName) {
        return (Set)this.fields.getNonNull(tableName);
    }

    private final List<String> getSQL() {
        return ChangeTable.cat(this.changeTables, this.root.getName());
    }

    final void execute() throws SQLException {
        List<String> sql = this.getSQL();
        if (sql.size() > 0) {
            for (String s : sql) {
                this.getRoot().getDBSystemRoot().getDataSource().execute(s);
            }
            this.getRoot().getSchema().updateVersion();
            for (String addedTable : this.getAddedTables()) {
                SQLTable.setUndefID(this.getRoot().getSchema(), addedTable, null);
            }
            this.getRoot().refetch();
        }
    }

    public final SQLCreateTable getCreateTable(String name) {
        if (this.root.contains(name)) {
            throw new IllegalArgumentException("Table already exists : " + name);
        }
        SQLCreateTable res = new SQLCreateTable(this.root, name);
        this.changeTables.add(res);
        return res;
    }

    public final AlterTableRestricted getAlterTable(String name) {
        AlterTableRestricted res = new AlterTableRestricted(this, name);
        this.changeTables.add(res.getAlter());
        this.alterTables.add(res);
        return res;
    }

    public final void dropTable(String name) {
        if (!this.getTablesPreviouslyCreated().contains(name)) {
            throw new IllegalArgumentException(String.valueOf(name) + "doesn't belong to this module");
        }
        this.changeTables.add(new DropTable(this.root.getTable(name)));
    }

    final List<String> getAddedTables() {
        ArrayList<String> res = new ArrayList<String>();
        for (ChangeTable<?> a : this.changeTables) {
            if (!(a instanceof SQLCreateTableBase)) continue;
            res.add(a.getName());
        }
        return res;
    }

    final List<SQLName> getAddedFieldsToExistingTables() {
        ArrayList<SQLName> res = new ArrayList<SQLName>();
        for (AlterTableRestricted a : this.alterTables) {
            for (String f : a.getAddedColumns()) {
                res.add(new SQLName(a.getName(), f));
            }
        }
        return res;
    }

    final List<String> getRemovedTables() {
        ArrayList<String> res = new ArrayList<String>();
        for (ChangeTable<?> a : this.changeTables) {
            if (!(a instanceof DropTable)) continue;
            res.add(a.getName());
        }
        return res;
    }

    final List<SQLName> getRemovedFieldsFromExistingTables() {
        ArrayList<SQLName> res = new ArrayList<SQLName>();
        for (AlterTableRestricted a : this.alterTables) {
            for (String f : a.getRemovedColumns()) {
                res.add(new SQLName(a.getName(), f));
            }
        }
        return res;
    }
}

