/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.view.DropManager;
import org.openconcerto.sql.view.FileDropHandler;
import org.openconcerto.sql.view.SQLMenuItemHelper;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.RowActionFactory;
import org.openconcerto.utils.CollectionMap;

public final class ComponentsContext {
    private final SQLElementDirectory dir;
    private final DBRoot root;
    private final Set<String> createdTables;
    private final CollectionMap<String, String> createdFields;
    private final CollectionMap<SQLElement, String> fields;
    private final CollectionMap<SQLElement, RowAction> rowActions;
    private final List<JMenuItem> menuItems;

    ComponentsContext(SQLElementDirectory dir, DBRoot root, Set<String> tables, Set<SQLName> fields) {
        this.dir = dir;
        this.root = root;
        this.createdTables = tables;
        this.createdFields = new CollectionMap();
        for (SQLName f : fields) {
            assert (f.getItemCount() == 2);
            String tableName = f.getFirst();
            if (this.createdTables.contains(tableName)) continue;
            this.createdFields.put((Object)tableName, (Object)f.getItem(1));
        }
        this.fields = new CollectionMap();
        this.rowActions = new CollectionMap();
        this.menuItems = new ArrayList<JMenuItem>();
    }

    private final DBRoot getRoot() {
        return this.root;
    }

    private final SQLElement checkField(String tableName, String name) {
        if (this.createdTables.contains(tableName)) {
            throw new IllegalArgumentException("The table " + tableName + " was created by this module");
        }
        if (!this.createdFields.getNonNull(tableName).contains(name)) {
            throw new IllegalArgumentException("The field " + new SQLName(tableName, name).quote() + " wasn't created by this module");
        }
        return this.getElement(tableName);
    }

    public final SQLElement getElement(String tableName) {
        return this.dir.getElement(this.getRoot().getTable(tableName));
    }

    public final void putAdditionalField(String tableName, String name) {
        SQLElement elem = this.checkField(tableName, name);
        if (!elem.putAdditionalField(name)) {
            throw new IllegalStateException("Already added " + name + " in " + elem);
        }
        this.fields.put((Object)elem, (Object)name);
    }

    public final void putAdditionalField(String tableName, String name, JTextComponent comp) {
        SQLElement elem = this.checkField(tableName, name);
        if (!elem.putAdditionalField(name, comp)) {
            throw new IllegalStateException("Already added " + name + " in " + elem);
        }
        this.fields.put((Object)elem, (Object)name);
    }

    public final void putAdditionalField(String tableName, String name, SQLTextCombo comp) {
        SQLElement elem = this.checkField(tableName, name);
        if (!elem.putAdditionalField(name, comp)) {
            throw new IllegalStateException("Already added " + name + " in " + elem);
        }
        this.fields.put((Object)elem, (Object)name);
    }

    final CollectionMap<SQLElement, String> getFields() {
        return this.fields;
    }

    public final void addRowAction(String tableName, RowAction action) {
        SQLElement elem = this.getElement(tableName);
        this.rowActions.put((Object)elem, (Object)action);
        elem.getRowActions().add(action);
    }

    public final void addRowActionFactory(RowActionFactory factory) {
        SQLElement elem = this.getElement(factory.getTableName());
        elem.getRowActionFactories().add(factory);
    }

    final CollectionMap<SQLElement, RowAction> getRowActions() {
        return this.rowActions;
    }

    public final SQLMenuItemHelper.SQLMenuItemAction createEditAction(String table) {
        return SQLMenuItemHelper.INSTANCE.createEditAction(this.getElement(table));
    }

    public final SQLMenuItemHelper.SQLMenuItemAction createListAction(String table) {
        return SQLMenuItemHelper.INSTANCE.createListAction(this.getElement(table));
    }

    public final void addMenuItem(Action action, String menu) {
        this.addMenuItem(action, menu, (String)null);
    }

    public final void addMenuItem(Action action, String menu, String group) {
        this.addMenuItem(action, new String[]{menu, group});
    }

    public final void addMenuItem(Action action, String ... path) {
        this.addMenuItem(action, Arrays.asList(path));
    }

    public final void addMenuItem(Action action, List<String> path) {
        JMenuItem item = MainFrame.getInstance().addMenuItem(action, path);
        this.menuItems.add(item);
    }

    final Collection<JMenuItem> getMenuItems() {
        return this.menuItems;
    }

    public final void addFileDropHandler(SQLTable table, FileDropHandler handler) {
        DropManager.getInstance().add(table, handler);
    }
}

