/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.openconcerto.erp.modules.AvailableModuleTableModel;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleFrame;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;

public class AvailableModulesPanel
extends JPanel {
    private final AvailableModuleTableModel tm;

    AvailableModulesPanel(final ModuleFrame moduleFrame) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.tm = new AvailableModuleTableModel();
        JTable t = new JTable(this.tm);
        t.setShowGrid(false);
        t.setShowVerticalLines(false);
        t.setFocusable(false);
        t.setRowSelectionAllowed(false);
        t.setColumnSelectionAllowed(false);
        t.setCellSelectionEnabled(false);
        t.getColumnModel().getColumn(0).setWidth(24);
        t.getColumnModel().getColumn(0).setPreferredWidth(24);
        t.getColumnModel().getColumn(0).setMaxWidth(24);
        t.getColumnModel().getColumn(0).setResizable(false);
        t.getColumnModel().getColumn(1).setMinWidth(100);
        t.getColumnModel().getColumn(2).setMinWidth(48);
        t.getColumnModel().getColumn(2).setPreferredWidth(48);
        t.getColumnModel().getColumn(3).setMinWidth(48);
        t.getColumnModel().getColumn(3).setPreferredWidth(200);
        t.getTableHeader().setReorderingAllowed(false);
        JScrollPane scroll = new JScrollPane(t);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridheight = 4;
        c.fill = 1;
        this.add((Component)scroll, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        ++c.gridx;
        c.fill = 0;
        c.gridheight = 1;
        JButton activateButton = new JButton(new AbstractAction("Installer"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Collection<ModuleFactory> checkedRows = AvailableModulesPanel.this.tm.getCheckedRows();
                ModuleManager mngr = ModuleManager.getInstance();
                try {
                    for (ModuleFactory f : checkedRows) {
                        mngr.startModule(f.getID(), true);
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle(AvailableModulesPanel.this, "Impossible de d\u00e9marrer les modules", e);
                }
                moduleFrame.reload();
            }
        });
        activateButton.setOpaque(false);
        this.add((Component)activateButton, c);
        JPanel space = new JPanel();
        space.setOpaque(false);
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)space, c);
    }

    public void reload() {
        this.tm.reload();
    }
}

