/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.utils.CollectionUtils;

public final class AlterTableRestricted {
    private final DBContext ctxt;
    private final SQLTable table;
    private final Set<SQLField> previouslyCreatedFields;
    private final AlterTable alter;
    private final Set<String> addedColumns;
    private final Set<String> removedColumns;

    AlterTableRestricted(DBContext ctxt, String tableName) {
        this.ctxt = ctxt;
        this.table = ctxt.getRoot().getTable(tableName);
        this.previouslyCreatedFields = ctxt.getFieldsPreviouslyCreated(tableName);
        this.alter = new AlterTable(this.table);
        this.addedColumns = new HashSet<String>();
        this.removedColumns = new HashSet<String>();
    }

    final AlterTable getAlter() {
        return this.alter;
    }

    final Set<String> getAddedColumns() {
        return this.addedColumns;
    }

    final Set<String> getRemovedColumns() {
        return this.removedColumns;
    }

    public final SQLSyntax getSyntax() {
        return this.alter.getSyntax();
    }

    public final String getName() {
        return this.alter.getName();
    }

    private void addCol(String name) {
        if (this.table.contains(name)) {
            throw new IllegalArgumentException(String.valueOf(name) + " already exists");
        }
        if (!this.addedColumns.add(name)) {
            throw new IllegalArgumentException(String.valueOf(name) + " already added to this");
        }
    }

    private void checkCol(String name) {
        SQLField f = this.table.getField(name);
        if (!this.previouslyCreatedFields.contains(f)) {
            throw new IllegalArgumentException(f + " doesn't belong to this module");
        }
    }

    public final AlterTable addColumn(String name, String definition) {
        this.addCol(name);
        return this.alter.addColumn(name, definition);
    }

    public final AlterTable addVarCharColumn(String name, int count) {
        this.addCol(name);
        return (AlterTable)this.alter.addVarCharColumn(name, count);
    }

    public final AlterTable addDateAndTimeColumn(String name) {
        this.addCol(name);
        return (AlterTable)this.alter.addDateAndTimeColumn(name);
    }

    public AlterTable addForeignColumn(String fk, String table) {
        return this.addForeignColumn(fk, new SQLName(table));
    }

    public AlterTable addForeignColumn(String fk, SQLName tableName) {
        if (tableName.getItemCount() == 1 && this.ctxt.getAddedTables().contains(tableName.getFirst())) {
            this.addCol(fk);
            return (AlterTable)this.alter.addForeignColumn(fk, tableName, "ID", "NULL");
        }
        return this.addForeignColumn(fk, this.table.getDesc(tableName, SQLTable.class));
    }

    public AlterTable addForeignColumn(String fk, SQLTable foreignTable) {
        this.addCol(fk);
        return (AlterTable)this.alter.addForeignColumn(fk, foreignTable);
    }

    public AlterTable addUniqueConstraint(String name, List<String> cols) {
        if (!this.addedColumns.containsAll(cols)) {
            throw new IllegalArgumentException("Can only add constraint to added columns : " + CollectionUtils.substract(cols, this.addedColumns));
        }
        return (AlterTable)this.alter.addUniqueConstraint(name, cols);
    }

    public final AlterTable alterColumn(String fname, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        this.checkCol(fname);
        return this.alter.alterColumn(fname, toAlter, type, defaultVal, nullable);
    }

    public final AlterTable alterColumnNullable(String f, boolean b) {
        this.checkCol(f);
        return this.alter.alterColumnNullable(f, b);
    }

    public final AlterTable dropColumn(String name) {
        this.checkCol(name);
        this.removedColumns.add(name);
        return this.alter.dropColumn(name);
    }

    public boolean isEmpty() {
        return this.alter.isEmpty();
    }

    public int hashCode() {
        return this.alter.hashCode();
    }

    public boolean equals(Object obj) {
        return this.alter.equals(obj);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.alter.toString();
    }
}

