/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModulePreferencePanelDesc;
import org.openconcerto.sql.element.SQLElementDirectory;

public abstract class AbstractModule {
    private final ModuleFactory factory;

    public AbstractModule(ModuleFactory f) throws IOException {
        this.factory = f;
    }

    public final ModuleFactory getFactory() {
        return this.factory;
    }

    public final String getName() {
        return this.getFactory().getName();
    }

    public final String getDescription() {
        return this.getFactory().getDescription();
    }

    public final int getVersion() {
        return this.getFactory().getMajorVersion();
    }

    protected void install(DBContext ctxt) {
    }

    protected void setupElements(SQLElementDirectory dir) {
    }

    protected void setupComponents(ComponentsContext ctxt) {
    }

    protected abstract void start();

    public List<ModulePreferencePanelDesc> getPrefDescriptors() {
        return Collections.emptyList();
    }

    public final Map<Boolean, List<ModulePreferencePanelDesc>> getPrefDescriptorsByLocation() {
        HashMap<Boolean, List<ModulePreferencePanelDesc>> res = new HashMap<Boolean, List<ModulePreferencePanelDesc>>();
        for (ModulePreferencePanelDesc desc : this.getPrefDescriptors()) {
            List<ModulePreferencePanelDesc> l;
            Boolean key = desc.isLocal();
            if (!res.containsKey(key)) {
                l = new ArrayList();
                res.put(key, l);
            } else {
                l = (List)res.get(key);
            }
            l.add(desc);
        }
        return res;
    }

    protected abstract void stop();

    protected void uninstall() {
    }
}

