/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.generationDoc.SpreadSheetGeneratorCompta;
import org.openconcerto.erp.generationDoc.gestcomm.ReleveChequeEmisSheet;
import org.openconcerto.erp.generationDoc.gestcomm.ReleveChequeSheet;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementAvoirChequeClient;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementChequeClient;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementChequeFourn;
import org.openconcerto.erp.model.LoadingTableListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFieldsSet;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ExceptionHandler;

public class GestionChequesModel
extends AbstractTableModel {
    private List<Map<String, Object>> cheque = new ArrayList<Map<String, Object>>();
    private SQLTableListener tableListener;
    private EventListenerList loadingListener = new EventListenerList();
    private SQLTable chqTable;
    private List<FieldRef> fields;
    private SQLField fieldSelect;
    private SQLField fieldDateMin;
    SwingWorker<String, Object> worker;
    public static final int MODE_ACHAT = 1;
    public static final int MODE_VENTE = 2;
    public static final int MODE_AVOIR = 3;

    public GestionChequesModel(SQLTable table, List<FieldRef> fields, SQLField select, SQLField fieldDate) {
        this.chqTable = table;
        this.fields = fields;
        this.fieldSelect = select;
        this.fieldDateMin = fieldDate;
        if (!fields.contains(select)) {
            throw new IllegalArgumentException("Le field select n'est dans aucune colonne.");
        }
        this.tableListener = new SQLTableListener(){

            @Override
            public void rowModified(SQLTable table, int id) {
                GestionChequesModel.this.loadCheque();
                GestionChequesModel.this.fireTableDataChanged();
            }

            @Override
            public void rowAdded(SQLTable table, int id) {
                GestionChequesModel.this.loadCheque();
                GestionChequesModel.this.fireTableDataChanged();
            }

            @Override
            public void rowDeleted(SQLTable table, int id) {
                GestionChequesModel.this.loadCheque();
                GestionChequesModel.this.fireTableDataChanged();
            }
        };
        this.chqTable.addTableListener(this.tableListener);
    }

    @Override
    public Class<?> getColumnClass(int c) {
        FieldRef field = this.fields.get(c);
        if (field.getField().getName().equalsIgnoreCase("ID_MOUVEMENT")) {
            return String.class;
        }
        return field.getField().getType().getJavaType();
    }

    @Override
    public int getRowCount() {
        return this.cheque.size();
    }

    @Override
    public int getColumnCount() {
        return this.fields.size();
    }

    @Override
    public String getColumnName(int col) {
        FieldRef field = this.fields.get(col);
        if (field.getField().getName().equalsIgnoreCase("ID_MOUVEMENT")) {
            return "Source";
        }
        return Configuration.getInstance().getTranslator().getLabelFor(field.getField());
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FieldRef field = this.fields.get(columnIndex);
        if (field.getField().getName().equalsIgnoreCase("ID_MOUVEMENT")) {
            return this.cheque.get(rowIndex).get("SOURCE_MOUVEMENT");
        }
        return this.cheque.get(rowIndex).get(field.getField().getName());
    }

    public void fireIsLoading(boolean b) {
        LoadingTableListener[] loadingTableListenerArray = (LoadingTableListener[])this.loadingListener.getListeners(LoadingTableListener.class);
        int n = loadingTableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LoadingTableListener l = loadingTableListenerArray[n2];
            l.isLoading(b);
            ++n2;
        }
    }

    public void addLoadingListener(LoadingTableListener l) {
        this.loadingListener.add(LoadingTableListener.class, l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.cheque.get(rowIndex).put(this.fields.get(columnIndex).getField().getName(), aValue);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.fields.get(col).equals(this.fieldSelect);
    }

    public void loadCheque() {
        if (this.worker != null && !this.worker.isDone()) {
            return;
        }
        this.fireIsLoading(true);
        this.worker = new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                SQLBase base = GestionChequesModel.this.chqTable.getBase();
                final SQLSelect selCheque = new SQLSelect(base);
                selCheque.setWaitPreviousWriteTX(true);
                Where w = new Where((FieldRef)GestionChequesModel.this.fieldSelect, "=", (Object)Boolean.FALSE);
                w = w.and(new Where((FieldRef)GestionChequesModel.this.chqTable.getField("REG_COMPTA"), "=", (Object)Boolean.FALSE));
                int i = 0;
                while (i < GestionChequesModel.this.fields.size()) {
                    FieldRef f = (FieldRef)GestionChequesModel.this.fields.get(i);
                    selCheque.addSelect(f);
                    if (!f.getField().getTable().equals(GestionChequesModel.this.chqTable)) {
                        Set<SQLField> s = GestionChequesModel.this.chqTable.getForeignKeys(f.getField().getTable());
                        if (s != null && s.size() > 0) {
                            for (SQLField field : s) {
                                w = w.and(new Where((FieldRef)field, "=", f.getField().getTable().getKey()));
                            }
                        } else {
                            AliasedTable aliasedTable = new AliasedTable(f.getField().getTable(), "CLIENT_COMMUN");
                            SQLTable clientTable = GestionChequesModel.this.chqTable.getForeignTable("ID_CLIENT");
                            w = w.and(new Where((FieldRef)GestionChequesModel.this.chqTable.getField("ID_CLIENT"), "=", clientTable.getKey()));
                            w = w.and(new Where((FieldRef)clientTable.getField("ID_CLIENT"), "=", aliasedTable.getField("ID")));
                        }
                    }
                    ++i;
                }
                selCheque.addSelect(GestionChequesModel.this.chqTable.getKey());
                selCheque.addSelect(GestionChequesModel.this.chqTable.getField("ID_MOUVEMENT"));
                selCheque.setWhere(w);
                String reqCheque = selCheque.asString();
                GestionChequesModel.this.cheque = (List)base.getDataSource().execute(reqCheque, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER){

                    @Override
                    public Set<? extends SQLData> getCacheModifiers() {
                        return new SQLFieldsSet(selCheque.getSelectFields()).getTables();
                    }
                });
                for (Map m : GestionChequesModel.this.cheque) {
                    Number i2 = (Number)m.get("ID_MOUVEMENT");
                    m.put("SOURCE_MOUVEMENT", "");
                    if (i2 == null || i2.intValue() <= 1) continue;
                    int idScr = MouvementSQLElement.getSourceId(i2.intValue());
                    SQLTable tableMvt = Configuration.getInstance().getDirectory().getElement("MOUVEMENT").getTable();
                    if (idScr <= 1) continue;
                    SQLRow rowMvt = tableMvt.getRow(idScr);
                    String source = rowMvt.getString("SOURCE");
                    int idSource = rowMvt.getInt("IDSOURCE");
                    SQLElement eltSource = Configuration.getInstance().getDirectory().getElement(source);
                    if (eltSource == null) continue;
                    SQLTable table = eltSource.getTable();
                    SQLRow rowSource = table.getRow(idSource);
                    Set<String> fields2 = table.getFieldsName();
                    if (rowSource == null) continue;
                    if (fields2.contains("NUMERO")) {
                        m.put("SOURCE_MOUVEMENT", rowSource.getString("NUMERO"));
                        continue;
                    }
                    if (!fields2.contains("NOM")) continue;
                    m.put("SOURCE_MOUVEMENT", rowSource.getString("NOM"));
                }
                return null;
            }

            @Override
            protected void done() {
                GestionChequesModel.this.fireTableDataChanged();
                GestionChequesModel.this.fireIsLoading(false);
            }
        };
        this.worker.execute();
    }

    public int getNbChequeSelected() {
        int nbCheq = 0;
        int i = 0;
        while (i < this.cheque.size()) {
            Map<String, Object> chqTmp = this.cheque.get(i);
            Boolean b = (Boolean)chqTmp.get(this.fieldSelect.getName());
            if (b != null && b.booleanValue()) {
                ++nbCheq;
            }
            ++i;
        }
        return nbCheq;
    }

    public long getMontantTotalSelected() {
        long montant = 0L;
        int i = 0;
        while (i < this.cheque.size()) {
            Map<String, Object> chqTmp = this.cheque.get(i);
            Boolean b = (Boolean)chqTmp.get(this.fieldSelect.getName());
            if (b != null && b.booleanValue()) {
                Long l = (Long)chqTmp.get("MONTANT");
                montant += l == null ? 0L : l;
            }
            ++i;
        }
        return montant;
    }

    public void selectionDecaisseAll() {
        if (this.cheque == null) {
            return;
        }
        int i = 0;
        while (i < this.cheque.size()) {
            Map<String, Object> chqTmp = this.cheque.get(i);
            Date d = (Date)chqTmp.get(this.fieldDateMin.getName());
            if (d != null && !d.after(new Date())) {
                chqTmp.put(this.fieldSelect.getName(), Boolean.TRUE);
            } else {
                chqTmp.put(this.fieldSelect.getName(), Boolean.FALSE);
            }
            ++i;
        }
        this.fireTableDataChanged();
    }

    public void deselectionAll() {
        int i = 0;
        while (i < this.cheque.size()) {
            Map<String, Object> chqTmp = this.cheque.get(i);
            chqTmp.put(this.fieldSelect.getName(), Boolean.FALSE);
            ++i;
        }
        this.fireTableDataChanged();
    }

    public Date getDateMinimum(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            return (Date)this.cheque.get(rowIndex).get(this.fieldDateMin.getName());
        }
        throw new IllegalArgumentException();
    }

    public int getIdAtRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            return ((Number)this.cheque.get(rowIndex).get(this.chqTable.getKey().getName())).intValue();
        }
        throw new IllegalArgumentException();
    }

    public void valideDepot(Date d, int mode, boolean print) {
        this.valideDepot(d, mode, print, null);
    }

    public void valideDepot(Date d, int mode, boolean print, String s) {
        HashMap<String, Comparable<Boolean>> m = new HashMap<String, Comparable<Boolean>>();
        if (mode == 2) {
            m.put("ENCAISSE", Boolean.TRUE);
            m.put("DATE_DEPOT", d);
        } else {
            m.put("DECAISSE", Boolean.TRUE);
            m.put("DATE_DECAISSE", d);
        }
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>(this.cheque);
        ArrayList<Integer> listeCheque = new ArrayList<Integer>();
        int i = 0;
        while (i < l.size()) {
            Map chqTmp = (Map)l.get(i);
            Boolean b = (Boolean)chqTmp.get(this.fieldSelect.getName());
            if (b != null && b.booleanValue()) {
                SQLRowValues valChq = new SQLRowValues(this.chqTable, m);
                Number id = (Number)chqTmp.get(this.chqTable.getKey().getName());
                SQLRow rowCheque = this.chqTable.getRow(id.intValue());
                if (!rowCheque.getBoolean(this.fieldSelect.getName()).booleanValue()) {
                    listeCheque.add(id.intValue());
                    try {
                        GenerationEcritures gen;
                        valChq.update(id.intValue());
                        Number idMvt = (Number)chqTmp.get("ID_MOUVEMENT");
                        if (mode == 3) {
                            gen = new GenerationMvtReglementAvoirChequeClient(idMvt.intValue(), Long.valueOf(chqTmp.get("MONTANT").toString()), d, id.intValue());
                            ((GenerationMvtReglementAvoirChequeClient)gen).genere();
                        } else if (mode == 1) {
                            new GenerationMvtReglementChequeFourn(idMvt.intValue(), Long.valueOf(chqTmp.get("MONTANT").toString()), id.intValue(), d);
                        } else if (mode == 2) {
                            gen = new GenerationMvtReglementChequeClient(idMvt.intValue(), Long.valueOf(chqTmp.get("MONTANT").toString()), d, id.intValue(), s);
                            ((GenerationMvtReglementChequeClient)gen).genere();
                        } else {
                            System.err.println("Aucune \u00e9criture g\u00e9n\u00e9rer pour le cheque " + id + " mode inconnu");
                        }
                    }
                    catch (SQLException e) {
                        System.err.println("Erreur pendant la mise \u00e0 jour dans la table " + valChq.getTable().getName());
                        ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration des \u00e9critures du ch\u00e9ques + " + this.chqTable.getName() + " ID : " + id);
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        if (print) {
            if (mode == 1) {
                ReleveChequeEmisSheet sheet = new ReleveChequeEmisSheet(listeCheque);
                new SpreadSheetGeneratorCompta(sheet, "ReleveChequeEmis", false, true);
            } else if (mode == 2) {
                ReleveChequeSheet sheet = new ReleveChequeSheet(listeCheque, d);
                sheet.genere(true, false);
            }
        }
    }

    public void printPreview(int mode) {
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>(this.cheque);
        ArrayList<Integer> listeCheque = new ArrayList<Integer>();
        int i = 0;
        while (i < l.size()) {
            Number id;
            SQLRow rowCheque;
            Map chqTmp = (Map)l.get(i);
            Boolean b = (Boolean)chqTmp.get(this.fieldSelect.getName());
            if (b != null && b.booleanValue() && !(rowCheque = this.chqTable.getRow((id = (Number)chqTmp.get(this.chqTable.getKey().getName())).intValue())).getBoolean(this.fieldSelect.getName()).booleanValue()) {
                listeCheque.add(id.intValue());
            }
            ++i;
        }
        if (mode == 1) {
            ReleveChequeEmisSheet sheet = new ReleveChequeEmisSheet(listeCheque);
            new SpreadSheetGeneratorCompta(sheet, "ReleveChequeEmis", false, true);
        } else if (mode == 2) {
            ReleveChequeSheet sheet = new ReleveChequeSheet(listeCheque, new Date(), true);
            sheet.genere(true, false);
        }
    }
}

