/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.importer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ArrayTableModel {
    private List<List<Object>> dataVector;
    private List<Class<?>> columnTypes;

    public ArrayTableModel(List<List<Object>> data) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty data");
        }
        int colCount = data.get(0).size();
        ArrayList types = new ArrayList();
        int i = 0;
        while (i < colCount) {
            types.add(Object.class);
            ++i;
        }
        this.init(data, types);
    }

    public ArrayTableModel(List<List<Object>> data, List<Class<?>> types) {
        this.init(data, types);
    }

    private void init(List<List<Object>> data, List<Class<?>> types) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty data");
        }
        int colCount = data.get(0).size();
        if (colCount != types.size()) {
            throw new IllegalArgumentException("Data raw count doesn't match types count");
        }
        this.dataVector = data;
        this.columnTypes = types;
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public int getColumnCount() {
        return this.columnTypes.size();
    }

    public Class<?> getColumnClass(int columnIndex) {
        return this.columnTypes.get(columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        List<Object> row = this.dataVector.get(rowIndex);
        return row.get(columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        List<Object> rowVector = this.dataVector.get(rowIndex);
        if (!aValue.getClass().equals(this.getColumnClass(columnIndex))) {
            throw new IllegalArgumentException(aValue + " should be an instance of " + this.getColumnClass(columnIndex) + " but is an instance of " + aValue.getClass());
        }
        rowVector.set(columnIndex, columnIndex);
    }

    public void dump() {
        this.dump(0, this.getRowCount());
    }

    public void dump(int start, int stop) {
        int rowCount = Math.min(this.getRowCount(), stop);
        int colCount = this.getColumnCount();
        System.out.print("Types: ");
        int j = 0;
        while (j < colCount) {
            Class<?> c = this.columnTypes.get(j);
            System.out.print(String.valueOf(j) + ":" + c.getSimpleName());
            if (j < colCount - 1) {
                System.out.print(",");
            }
            ++j;
        }
        System.out.println();
        int i = start;
        while (i < rowCount) {
            int j2 = 0;
            while (j2 < colCount) {
                Object v = this.getValueAt(i, j2);
                if (v != null) {
                    System.out.print("[" + j2 + ":" + v.getClass().getSimpleName() + "]" + v);
                } else {
                    System.out.print("[" + j2 + "] null");
                }
                if (j2 < colCount - 1) {
                    System.out.print(",");
                }
                ++j2;
            }
            System.out.println();
            ++i;
        }
    }

    public Set<Object> getValueSetForColumn(int column) {
        HashSet<Object> result = new HashSet<Object>();
        int rowCount = this.getRowCount();
        int i = 0;
        while (i < rowCount) {
            Object v = this.getValueAt(i, column);
            result.add(v);
            ++i;
        }
        return result;
    }
}

