/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementAchat;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtSaisieAchat
extends GenerationEcritures
implements Runnable {
    private int idSaisieAchat;
    private static final String source = "SAISIE_ACHAT";
    private static final Integer journal = new Integer(2);
    private static final SQLTable tableSaisieAchat = base.getTable("SAISIE_ACHAT");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableFournisseur = base.getTable("FOURNISSEUR");
    private static final SQLTable tableMvt = base.getTable("MOUVEMENT");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtSaisieAchat(int idSaisieAchat, int idMvt) {
        this.idSaisieAchat = idSaisieAchat;
        this.idMvt = idMvt;
        new Thread(this).start();
    }

    public GenerationMvtSaisieAchat(int idSaisieAchat) {
        this.idSaisieAchat = idSaisieAchat;
        this.idMvt = 1;
        new Thread(this).start();
    }

    public void genereMouvement() throws IllegalArgumentException {
        int idCompteFourn;
        SQLRow saisieRow = tableSaisieAchat.getRow(this.idSaisieAchat);
        SQLRow rowFournisseur = tableFournisseur.getRow(saisieRow.getInt("ID_FOURNISSEUR"));
        this.date = (Date)saisieRow.getObject("DATE");
        this.nom = "Achat : " + rowFournisseur.getString("NOM") + " Facture : " + saisieRow.getObject("NUMERO_FACTURE").toString() + " " + saisieRow.getObject("NOM").toString();
        this.mEcritures.put("DATE", this.date);
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("ID_JOURNAL", journal);
        this.mEcritures.put("ID_MOUVEMENT", new Integer(1));
        PrixTTC prixTTC = new PrixTTC((Long)saisieRow.getObject("MONTANT_TTC"));
        PrixHT prixTVA = new PrixHT((Long)saisieRow.getObject("MONTANT_TVA"));
        PrixHT prixHT = new PrixHT((Long)saisieRow.getObject("MONTANT_HT"));
        if (this.idMvt == 1) {
            this.getNewMouvement(source, this.idSaisieAchat, 1, " Saisie Achat " + saisieRow.getObject("NUMERO_FACTURE").toString());
        } else {
            SQLRow rowMvt = tableMvt.getRow(this.idMvt);
            SQLRowValues rowPiece = rowMvt.getForeignRow("ID_PIECE").createEmptyUpdateRow();
            rowPiece.put("NOM", " Saisie Achat " + saisieRow.getObject("NUMERO_FACTURE").toString());
            try {
                rowPiece.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.mEcritures.put("ID_MOUVEMENT", new Integer(this.idMvt));
        }
        int idCompteAchat = saisieRow.getInt("ID_COMPTE_PCE");
        if (idCompteAchat <= 1 && (idCompteAchat = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACHAT")) <= 1) {
            try {
                idCompteAchat = ComptePCESQLElement.getIdComptePceDefault("Achats");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteAchat));
        this.mEcritures.put("DEBIT", new Long(prixHT.getLongValue()));
        this.mEcritures.put("CREDIT", new Long(0L));
        this.ajoutEcriture();
        if (prixTVA.getLongValue() > 0L) {
            int idCompteTVA;
            if (saisieRow.getBoolean("IMMO").booleanValue()) {
                idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_IMMO");
                if (idCompteTVA <= 1) {
                    try {
                        idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVAImmo");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_ACHAT");
                if (idCompteTVA <= 1) {
                    try {
                        idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVADeductible");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteTVA));
            this.mEcritures.put("DEBIT", new Long(prixTVA.getLongValue()));
            this.mEcritures.put("CREDIT", new Long(0L));
            this.ajoutEcriture();
            if (rowFournisseur.getBoolean("UE").booleanValue()) {
                int idCompteTVAIntra = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_INTRA");
                if (idCompteTVAIntra <= 1) {
                    try {
                        idCompteTVAIntra = ComptePCESQLElement.getIdComptePceDefault("TVAIntraComm");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteTVAIntra));
                this.mEcritures.put("DEBIT", new Long(0L));
                this.mEcritures.put("CREDIT", new Long(prixTVA.getLongValue()));
                this.ajoutEcriture();
            }
        }
        if ((idCompteFourn = rowFournisseur.getInt("ID_COMPTE_PCE")) <= 1 && (idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
            try {
                idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteFourn));
        this.mEcritures.put("DEBIT", new Long(0L));
        if (rowFournisseur.getBoolean("UE").booleanValue()) {
            this.mEcritures.put("CREDIT", new Long(prixHT.getLongValue()));
        } else {
            this.mEcritures.put("CREDIT", new Long(prixTTC.getLongValue()));
        }
        this.ajoutEcriture();
        new GenerationMvtReglementAchat(this.idSaisieAchat, this.idMvt);
        SQLRowValues valEcriture = new SQLRowValues(tableSaisieAchat);
        valEcriture.put("ID_MOUVEMENT", new Integer(this.idMvt));
        try {
            if (valEcriture.getInvalid() == null) {
                valEcriture.update(this.idSaisieAchat);
            }
        }
        catch (SQLException e) {
            System.err.println("Erreur \u00e0 l'insertion dans la table " + tableSaisieAchat.getName() + " : " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            this.genereMouvement();
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
    }
}

