/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtAvoirFournisseur
extends GenerationEcritures {
    private static final String source = "AVOIR_FOURNISSEUR";
    private static final Integer journal = 2;
    private int idAvoirFourn;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtAvoirFournisseur(int idAvoirFourn) {
        this.idMvt = 1;
        this.idAvoirFourn = idAvoirFourn;
    }

    public GenerationMvtAvoirFournisseur(int idAvoirFourn, int idMvt) {
        this.idMvt = idMvt;
        this.idAvoirFourn = idAvoirFourn;
    }

    public int genereMouvement() {
        SQLTable avoirFournTable = base.getTable(source);
        SQLTable fournTable = base.getTable("FOURNISSEUR");
        SQLRow avoirRow = avoirFournTable.getRow(this.idAvoirFourn);
        SQLRow rowFourn = fournTable.getRow(avoirRow.getInt("ID_FOURNISSEUR"));
        PrixTTC prixTTC = new PrixTTC((Long)avoirRow.getObject("MONTANT_TTC"));
        PrixHT prixHT = new PrixHT((Long)avoirRow.getObject("MONTANT_HT"));
        PrixHT prixTVA = new PrixHT((Long)avoirRow.getObject("MONTANT_TVA"));
        this.date = (Date)avoirRow.getObject("DATE");
        this.nom = avoirRow.getObject("NOM").toString();
        this.mEcritures.put("DATE", new java.sql.Date(this.date.getTime()));
        this.mEcritures.put("NOM", "Avoir fournisseur : " + avoirRow.getString("NUMERO") + " " + rowFourn.getString("NOM"));
        this.mEcritures.put("ID_JOURNAL", journal);
        this.mEcritures.put("ID_MOUVEMENT", 1);
        if (this.idMvt == 1) {
            this.getNewMouvement(source, this.idAvoirFourn, 1, "Avoir Fournisseur : " + avoirRow.getString("NUMERO"));
        } else {
            this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
        }
        int idCompteAchat = avoirRow.getInt("ID_COMPTE_PCE");
        if (idCompteAchat <= 1 && (idCompteAchat = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACHAT")) <= 1) {
            try {
                idCompteAchat = ComptePCESQLElement.getIdComptePceDefault("Achats");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mEcritures.put("ID_COMPTE_PCE", idCompteAchat);
        this.mEcritures.put("DEBIT", 0L);
        this.mEcritures.put("CREDIT", prixHT.getLongValue());
        try {
            int idCompteFourn;
            this.ajoutEcriture();
            if (prixTVA.getLongValue() > 0L) {
                int idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_ACHAT");
                if (avoirRow.getBoolean("IMMO").booleanValue()) {
                    idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_IMMO");
                    if (idCompteTVA <= 1) {
                        try {
                            idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVAImmo");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_ACHAT");
                    if (idCompteTVA <= 1) {
                        try {
                            idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVADeductible");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.mEcritures.put("ID_COMPTE_PCE", idCompteTVA);
                this.mEcritures.put("DEBIT", 0L);
                this.mEcritures.put("CREDIT", prixTVA.getLongValue());
                this.ajoutEcriture();
                if (rowFourn.getBoolean("UE").booleanValue()) {
                    int idCompteTVAIntra = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_INTRA");
                    if (idCompteTVAIntra <= 1) {
                        try {
                            idCompteTVAIntra = ComptePCESQLElement.getIdComptePceDefault("TVAIntraComm");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.mEcritures.put("ID_COMPTE_PCE", idCompteTVAIntra);
                    this.mEcritures.put("DEBIT", prixTVA.getLongValue());
                    this.mEcritures.put("CREDIT", 0L);
                    this.ajoutEcriture();
                }
            }
            if ((idCompteFourn = rowFourn.getInt("ID_COMPTE_PCE")) <= 1 && (idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
                try {
                    idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", idCompteFourn);
            this.mEcritures.put("DEBIT", prixTTC.getLongValue());
            this.mEcritures.put("CREDIT", 0L);
            this.ajoutEcriture();
            SQLRowValues valAvoir = new SQLRowValues(avoirFournTable);
            valAvoir.put("ID_MOUVEMENT", (Object)this.idMvt);
            try {
                if (valAvoir.getInvalid() == null) {
                    valAvoir.update(this.idAvoirFourn);
                }
            }
            catch (SQLException e) {
                System.err.println("Erreur \u00e0 l'insertion dans la table " + avoirFournTable.getName() + " : " + e);
                e.printStackTrace();
            }
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
        return this.idMvt;
    }
}

