/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.Tuple2;

public class FicheRelanceSheet
extends AbstractListeSheetXml {
    private static final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    private SQLRow row;

    public static Tuple2<String, String> getTuple2Location() {
        return tupleDefault;
    }

    public FicheRelanceSheet(SQLRow row) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.row = row;
        this.locationOO = SheetXml.getLocationForTuple(tupleDefault, false);
        this.locationPDF = SheetXml.getLocationForTuple(tupleDefault, true);
        this.modele = "FicheRelance";
    }

    @Override
    protected void createListeValues() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        ArrayList listValues = new ArrayList();
        SQLRow clientRow = this.row.getForeignRow("ID_CLIENT");
        SQLRow factureRow = this.row.getForeignRow("ID_SAISIE_VENTE_FACTURE");
        values.put("CLIENT", clientRow.getString("NOM"));
        values.put("DATE_RELANCE", this.row.getDate("DATE").getTime());
        values.put("TEL", String.valueOf(clientRow.getString("TEL")) + "\n" + clientRow.getString("FAX"));
        values.put("NUMERO_FACTURE", factureRow.getString("NUMERO"));
        values.put("DATE_FACTURE", dateFormat.format(factureRow.getDate("DATE").getTime()));
        values.put("MONTANT", GestionDevise.currencyToString(factureRow.getLong("T_TTC")));
        values.put("INFOS", this.row.getString("INFOS"));
        this.listAllSheetValues.put(0, listValues);
        this.mapAllSheetValues.put(0, values);
    }

    @Override
    public String getFileName() {
        return FicheRelanceSheet.getValidFileName("FicheRelance" + new Date().getTime());
    }
}

