/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.Tuple2;

public class EtatVentesXmlSheet
extends AbstractListeSheetXml {
    private static final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    private Timestamp du;
    private Timestamp au;

    public static Tuple2<String, String> getTuple2Location() {
        return tupleDefault;
    }

    public EtatVentesXmlSheet(Date du, Date au) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        du.setHours(0);
        du.setMinutes(0);
        au.setHours(23);
        au.setMinutes(59);
        this.du = new Timestamp(du.getTime());
        this.au = new Timestamp(au.getTime());
        this.modele = "EtatVentes";
        this.locationOO = SheetXml.getLocationForTuple(tupleDefault, false);
        this.locationPDF = SheetXml.getLocationForTuple(tupleDefault, true);
    }

    @Override
    public String getFileName() {
        return EtatVentesXmlSheet.getValidFileName("EtatVentes" + new Date().getTime());
    }

    @Override
    protected void createListeValues() {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        SQLElement elt2 = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLElement eltEnc = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT");
        SQLElement elt3 = Configuration.getInstance().getDirectory().getElement("TICKET_CAISSE");
        SQLElement eltMod = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
        AliasedTable table1 = new AliasedTable(eltMod.getTable(), "mod1");
        AliasedTable tableTicket = new AliasedTable(elt3.getTable(), "ticket");
        AliasedTable table2 = new AliasedTable(eltMod.getTable(), "mod2");
        SQLSelect sel = new SQLSelect(Configuration.getInstance().getBase());
        sel.addSelect(elt.getTable().getField("NOM"));
        sel.addSelect(elt.getTable().getField("T_PA_HT"), "SUM");
        sel.addSelect(elt.getTable().getField("T_PV_HT"), "SUM");
        sel.addSelect(elt.getTable().getField("T_PV_TTC"), "SUM");
        sel.addSelect(elt.getTable().getField("QTE"), "SUM");
        sel.addSelect(elt.getTable().getField("CODE"));
        Where w = new Where((FieldRef)elt.getTable().getField("ID_TICKET_CAISSE"), "=", 1);
        sel.addJoin("LEFT", elt.getTable().getField("ID_SAISIE_VENTE_FACTURE")).setWhere(w);
        Where w2 = new Where((FieldRef)elt.getTable().getField("ID_SAISIE_VENTE_FACTURE"), "=", 1);
        sel.addJoin("LEFT", elt2.getTable().getField("ID_MODE_REGLEMENT"), "mod1");
        sel.addJoin("LEFT", elt.getTable().getField("ID_TICKET_CAISSE"), "ticket").setWhere(w2);
        sel.addBackwardJoin("LEFT", "enc", eltEnc.getTable().getField("ID_TICKET_CAISSE"), "ticket");
        sel.addJoin("LEFT", new AliasedField(eltEnc.getTable().getField("ID_MODE_REGLEMENT"), "enc"), "mod2");
        sel.addRawSelect("SUM(CASE WHEN " + table1.getField("ID_TYPE_REGLEMENT").getFieldRef() + " =2 OR " + table2.getField("ID_TYPE_REGLEMENT").getFieldRef() + "=2 THEN " + sel.getAlias(elt.getTable().getField("QTE")).getFieldRef() + " ELSE 0 END)", "Cheque");
        sel.addRawSelect("SUM(CASE WHEN " + table1.getField("ID_TYPE_REGLEMENT").getFieldRef() + "=3 OR " + table2.getField("ID_TYPE_REGLEMENT").getFieldRef() + "=3 THEN " + sel.getAlias(elt.getTable().getField("QTE")).getFieldRef() + " ELSE 0 END)", "CB");
        sel.addRawSelect("SUM(CASE WHEN " + table1.getField("ID_TYPE_REGLEMENT").getFieldRef() + "=4 OR " + table2.getField("ID_TYPE_REGLEMENT").getFieldRef() + "=4 THEN " + sel.getAlias(elt.getTable().getField("QTE")).getFieldRef() + " ELSE 0 END)", "Especes");
        Where w3 = new Where((FieldRef)tableTicket.getField("DATE"), this.du, (Object)this.au);
        Where w4 = new Where((FieldRef)elt2.getTable().getField("DATE"), this.du, (Object)this.au);
        sel.setWhere(w3.or(w4));
        sel.addGroupBy(elt.getTable().getField("NOM"));
        sel.addGroupBy(elt.getTable().getField("CODE"));
        System.err.println(sel.asString());
        List listeIds = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
        if (listeIds == null) {
            return;
        }
        ArrayList<Object> listValues = new ArrayList<Object>(listeIds.size());
        double totalTPA = 0.0;
        double totalTPVTTC = 0.0;
        for (Object[] obj : listeIds) {
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            mValues.put("NOM", obj[0]);
            mValues.put("QTE", obj[4]);
            Double tPA = new Double((double)((Number)obj[1]).longValue() / 100.0);
            mValues.put("T_PA", tPA);
            Double tPVHT = new Double((double)((Number)obj[2]).longValue() / 100.0);
            mValues.put("T_PV_HT", tPVHT);
            Double TPVTTC = new Double((double)((Number)obj[3]).longValue() / 100.0);
            mValues.put("T_PV_TTC", TPVTTC);
            mValues.put("NB_CHEQUE", obj[6]);
            mValues.put("NB_CB", obj[7]);
            mValues.put("NB_ESPECES", obj[8]);
            totalTPA += tPA.doubleValue();
            totalTPVTTC += TPVTTC.doubleValue();
            listValues.add(mValues);
        }
        SQLTable venteComptoirT = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_COMPTOIR").getTable();
        SQLSelect selVC = new SQLSelect(venteComptoirT.getBase());
        selVC.addSelect(venteComptoirT.getField("NOM"));
        selVC.addSelect(venteComptoirT.getField("MONTANT_HT"), "SUM");
        selVC.addSelect(venteComptoirT.getField("MONTANT_TTC"), "SUM");
        selVC.addSelect(venteComptoirT.getField("NOM"), "COUNT");
        Where wVC = new Where((FieldRef)venteComptoirT.getField("DATE"), this.du, (Object)this.au);
        wVC = wVC.and(new Where((FieldRef)venteComptoirT.getField("ID_ARTICLE"), "=", venteComptoirT.getForeignTable("ID_ARTICLE").getKey()));
        selVC.setWhere(wVC);
        selVC.addGroupBy(venteComptoirT.getField("NOM"));
        List listVC = (List)venteComptoirT.getDBSystemRoot().getDataSource().execute(selVC.asString(), new ArrayListHandler());
        double totalVC = 0.0;
        if (listVC.size() > 0) {
            HashMap<String, String> mValues = new HashMap<String, String>();
            mValues.put("NOM", " ");
            listValues.add(mValues);
            HashMap mValues2 = new HashMap();
            if (listVC.size() > 1) {
                mValues2.put("NOM", "VENTES COMPTOIR");
            } else {
                mValues2.put("NOM", "VENTE COMPTOIR");
            }
            HashMap<Integer, String> style = (HashMap<Integer, String>)this.styleAllSheetValues.get(0);
            if (style == null) {
                style = new HashMap<Integer, String>();
            }
            style.put(listValues.size(), "Titre 1");
            this.styleAllSheetValues.put(0, style);
            listValues.add(mValues2);
        }
        for (Object[] row : listVC) {
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            mValues.put("NOM", row[0]);
            Double ht = new Double((double)((Number)row[1]).longValue() / 100.0);
            Double ttc = new Double((double)((Number)row[2]).longValue() / 100.0);
            mValues.put("QTE", row[3]);
            mValues.put("T_PV_HT", ht);
            mValues.put("T_PV_TTC", ttc);
            totalVC += ttc.doubleValue();
            listValues.add(mValues);
        }
        ArrayList listValuesHA = new ArrayList(listeIds.size());
        HashMap<String, Object> valuesHA = (HashMap<String, Object>)this.mapAllSheetValues.get(1);
        if (valuesHA == null) {
            valuesHA = new HashMap<String, Object>();
        }
        SQLElement eltAchat = Configuration.getInstance().getDirectory().getElement("SAISIE_ACHAT");
        SQLSelect selAchat = new SQLSelect(Configuration.getInstance().getBase());
        selAchat.addSelect(eltAchat.getTable().getField("NOM"));
        selAchat.addSelect(eltAchat.getTable().getField("MONTANT_HT"), "SUM");
        selAchat.addSelect(eltAchat.getTable().getField("MONTANT_TTC"), "SUM");
        Where wHA = new Where((FieldRef)eltAchat.getTable().getField("DATE"), this.du, (Object)this.au);
        selAchat.setWhere(wHA);
        selAchat.addGroupBy(eltAchat.getTable().getField("NOM"));
        List listAchat = (List)Configuration.getInstance().getBase().getDataSource().execute(selAchat.asString(), new ArrayListHandler());
        double totalHA = 0.0;
        for (Object[] row : listAchat) {
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            mValues.put("NOM", row[0]);
            Double ht = new Double((double)((Number)row[1]).longValue() / 100.0);
            Double pA = new Double((double)((Number)row[2]).longValue() / 100.0);
            mValues.put("T_PV_HT", -ht.doubleValue());
            mValues.put("T_PV_TTC", -pA.doubleValue());
            totalHA -= pA.doubleValue();
            listValuesHA.add(mValues);
        }
        totalTPVTTC += totalVC;
        HashMap<String, Object> valuesE = (HashMap<String, Object>)this.mapAllSheetValues.get(2);
        if (valuesE == null) {
            valuesE = new HashMap<String, Object>();
        }
        SQLElement eltE = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT");
        SQLElement eltM = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
        SQLElement eltT = Configuration.getInstance().getDirectory().getElement("TYPE_REGLEMENT");
        SQLSelect selE = new SQLSelect(Configuration.getInstance().getBase());
        selE.addSelect(eltT.getTable().getField("NOM"));
        selE.addSelect(eltT.getTable().getField("NOM"), "COUNT");
        selE.addSelect(eltE.getTable().getField("MONTANT"), "SUM");
        Where wE = new Where((FieldRef)eltE.getTable().getField("DATE"), this.du, (Object)this.au);
        wE = wE.and(new Where((FieldRef)eltE.getTable().getField("ID_MODE_REGLEMENT"), "=", eltM.getTable().getKey()));
        wE = wE.and(new Where((FieldRef)eltM.getTable().getField("ID_TYPE_REGLEMENT"), "=", eltT.getTable().getKey()));
        selE.setWhere(wE);
        selE.addGroupBy(eltT.getTable().getField("NOM"));
        selE.addFieldOrder(eltT.getTable().getField("NOM"));
        List listE = (List)Configuration.getInstance().getBase().getDataSource().execute(selE.asString(), new ArrayListHandler());
        ArrayList listValuesE = new ArrayList(listeIds.size());
        double totalE = 0.0;
        for (Object[] o : listE) {
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            mValues.put("NOM", o[0]);
            Double pA = new Double((double)((Number)o[2]).longValue() / 100.0);
            mValues.put("QTE", o[1]);
            mValues.put("TOTAL", pA);
            totalE += pA.doubleValue();
            listValuesE.add(mValues);
        }
        HashMap<String, Object> values = (HashMap<String, Object>)this.mapAllSheetValues.get(0);
        if (values == null) {
            values = new HashMap<String, Object>();
        }
        valuesHA.put("TOTAL", totalHA);
        valuesE.put("TOTAL_HA", totalHA);
        valuesE.put("TOTAL", totalE);
        valuesE.put("TOTAL_VT", totalTPVTTC);
        values.put("TOTAL", totalVC);
        values.put("TOTAL_MARGE", totalTPVTTC - totalTPA);
        valuesE.put("TOTAL_GLOBAL", totalTPVTTC + totalHA);
        values.put("TOTAL_PA", totalTPA);
        values.put("TOTAL_PV_TTC", totalTPVTTC);
        String periode = "P\u00e9riode Du " + dateFormat.format(this.du) + " au " + dateFormat.format(this.au);
        values.put("DATE", periode);
        valuesHA.put("DATE", periode);
        valuesE.put("DATE", periode);
        System.err.println(this.du);
        System.err.println(this.au);
        this.listAllSheetValues.put(0, listValues);
        this.mapAllSheetValues.put(0, values);
        this.listAllSheetValues.put(1, listValuesHA);
        this.mapAllSheetValues.put(1, valuesHA);
        this.listAllSheetValues.put(2, listValuesE);
        this.mapAllSheetValues.put(2, valuesE);
    }
}

